#!/bin/sh
# Automatically generated launch script
# ANY EDITS WILL BE OVERWRITTEN ON BUILD
# Thu Aug 20 17:19:53 UTC 2015
# All comments and extras will be removed in GoldMaster

## DEBUGGING - Uncomment these lines for testing purposes
#
## Run with GDB as the debugger
# DEBUGGER="gdb" 
#
## Run with apitrace
# DEBUGGER="apitrace trace" 
#
## Automatically backup old preferences and start fresh on launch
# date +%y%m%d-%H%M | xargs -i mv ~/.local/share/feral-interactive/AlienIsolation ~/.local/share/feral-interactive/AlienIsolation.{}.bak
#
## Show a version panel on start
# zenity --text-info --title "AlienIsolation - Version Information" --filename version
# 
## Run with glc as the debugger for screen capture
# GLCFILE="AlienIsolation_$(date +%y%m%d-%H%M)"
# mkdir -p /tmp/ScreenCaptures && DEBUGGER="glc-capture -o /tmp/ScreenCaptures/${GLCFILE}.glc"

# Set the steam appid variable, this allows us to launch from test apps
# Important note: do not set SteamGameId, steam uses this to know that this is the same app it launched.
if [ "${SteamAppId}" != "214490" ]; then
	export SteamAppId="214490"
fi

# cd to the game root
GAMEROOT=$(cd "${0%/*}" && echo $PWD)
cd "$GAMEROOT/bin"

# Launch with the debugger if set
${DEBUGGER} "${GAMEROOT}/bin/AlienIsolation" $@
RESULT=$?

## DEBUGGING - Uncomment these lines for testing purposes
#
## Automatically convert the glc file to mp4, must be pared with command above, remove all steam library stuff first
# test -f "/tmp/ScreenCaptures/${GLCFILE}.glc" && LD_PRELOAD="" && LD_LIBRARY_PATH="" && glc-play "/tmp/ScreenCaptures/${GLCFILE}.glc" -o - -y 1 | ffmpeg -i - -y ~/.local/share/feral-interactive/AlienIsolation/${GLCFILE}.mp4

exit ${RESULT}

