#!/bin/sh

outfile=$1

if [ ! -n "$outfile" ] ; then
	echo "Filename parameter omitted"
	exit 1
fi


echo "----Beginning Feral System Report----" > "$outfile"

write_error=$?

if [ $write_error != 0 ] ; then
	exit $write_error
fi

set -- $(echo "/etc/*-release") "/etc/X11/default-display-manager" "/etc/sysconfig/displaymanager" "/etc/sysconfig/desktop" "/proc/meminfo" "/proc/cpuinfo"


for file do
	if [ -e $file ] ; then
		echo "--------------------------------------------------------------------------------" >> "$outfile"
		echo "----Logging file: '$file'----" >> "$outfile"
		echo "--------------------------------------------------------------------------------" >> "$outfile"
		cat $file 2>&1 | head -n 500 | tee -a "$outfile" | 
		if [ "$(wc -l)" = "500" ]; 
			then echo "----File Truncated----" >> "$outfile"; 
		fi
	else
		echo "--------------------------------------------------------------------------------" >> "$outfile"
		echo "----File not found: '$file'----" >> "$outfile"
	fi
done


set -- "uname -a" "lsb_release -a" "ps -e" "env" "top -b -n 1" "nvidia-smi" "fglrxinfo" "lspci -v" "glxinfo" 


for cmd do
	echo "--------------------------------------------------------------------------------" >> "$outfile"
	echo "----Running command: '$cmd'----" >> "$outfile"
	echo "--------------------------------------------------------------------------------" >> "$outfile"
	$cmd 2>&1 | head -n 500 | tee -a "$outfile" | 
	if [ "$(wc -l)" = "500" ]; then 
		echo "----File Truncated----" >> "$outfile"; 
	fi
done

exit 0
