#!/bin/sh
# Automatically generated launch script
# ANY EDITS WILL BE OVERWRITTEN ON BUILD
# Fri Apr 29 11:48:22 UTC 2016
# All comments and extras will be removed in GoldMaster

# Magic to get the root folder
GAMEROOT=$(cd "${0%/*}" && echo $PWD)

## DEBUGGING - Uncomment these lines for testing purposes
#
## Run with GDB as the debugger
# DEBUGGER="gdb" 
#
## Run with apitrace
# DEBUGGER="apitrace trace" 
#
## Automatically backup old preferences and start fresh on launch
# date +%y%m%d-%H%M | xargs -i mv ~/.local/share/feral-interactive/F12015 ~/.local/share/feral-interactive/F12015.{}.bak
#
## Show a version panel on start
# zenity --text-info --title "F12015 - Version Information" --filename version
# 
## Run with glc as the debugger for screen capture
# GLCFILE="F12015_$(date +%y%m%d-%H%M)"
# mkdir -p /tmp/ScreenCaptures && DEBUGGER="glc-capture -o /tmp/ScreenCaptures/${GLCFILE}.glc"

# Set the steam appid variable, this allows us to launch from test apps
# Important note: do not set SteamGameId, steam uses this to know that this is the same app it launched.
if [ "${SteamAppId}" != "286570" ]; then
	export SteamAppId="286570"
fi

# AMD drivers run faster with TCMalloc.
HAS_CATALYST="$(grep fglrx /proc/modules)"
if [ -n "${HAS_CATALYST}" ]; then
	LD_PRELOAD="../lib/x86_64/libtcmalloc_minimal.so:${LD_PRELOAD}"
	export LD_PRELOAD
fi

# Fix FMOD not loading system libasound on Ubuntu 14.04
HAS_LSB_RELEASE=$(command -v lsb_release)
if [ -n "${HAS_LSB_RELEASE}" ] && [ "$(lsb_release -c | cut -f2)" = "trusty" ]; then
	LD_PRELOAD="/usr/lib/x86_64-linux-gnu/libasound.so.2:${LD_PRELOAD}"
	export LD_PRELOAD
fi

# Unset LC_ALL that can cause us issues, and is only used for debugging
unset LC_ALL

# Try and set up SSL paths for all distros, needed due to steam runtime bug #52
HAS_CURL=$( command -v curl-config )
if [ -n "${HAS_CURL}" ]; then
	SSL_CERT_FILE="$( curl-config --ca )"
else
	# Otherwise try with guesswork, 
	if [ -e "/etc/ssl/certs/ca-certificates.crt" ]; then
		SSL_CERT_FILE="/etc/ssl/certs/ca-certificates.crt"
	elif [ -e "/etc/pki/tls/certs/ca-bundle.crt"]; then
		SSL_CERT_FILE="/etc/pki/tls/certs/ca-bundle.crt"
	elif [ -e "/var/lib/ca-certificates/ca-bundle.pem" ]; then
		SSL_CERT_FILE="/var/lib/ca-certificates/ca-bundle.pem"
	fi
fi
export SSL_CERT_FILE
HAS_OPENSSL=$( command -v openssl )
if [ -n "${HAS_OPENSSL}" ]; then
	SSL_CERT_DIR="$( openssl version -d | sed -E 's/.*\"(.*)\"/\1/' )/certs"
	export SSL_CERT_DIR
fi

# cd to the game root
cd "$GAMEROOT/bin"

# Launch with the debugger if set
${DEBUGGER} "${GAMEROOT}/bin/F12015" $@
RESULT=$?

## DEBUGGING - Uncomment these lines for testing purposes
#
## Automatically convert the glc file to mp4, must be pared with command above, remove all steam library stuff first
# test -f "/tmp/ScreenCaptures/${GLCFILE}.glc" && LD_PRELOAD="" && LD_LIBRARY_PATH="" && glc-play "/tmp/ScreenCaptures/${GLCFILE}.glc" -o - -y 1 | ffmpeg -i - -y ~/.local/share/feral-interactive/F12015/${GLCFILE}.mp4

exit ${RESULT}

