#!/bin/sh
# Automatically generated launch script
# ANY EDITS WILL BE OVERWRITTEN ON BUILD
# Tue Dec  1 15:28:13 UTC 2015
# All comments and extras will be removed in GoldMaster

# Magic to get the root folder
GAMEROOT=$(cd "${0%/*}" && echo $PWD)

## DEBUGGING - Uncomment these lines for testing purposes
#
## Run with GDB as the debugger
# DEBUGGER="gdb" 
#
## Run with apitrace
# DEBUGGER="apitrace trace" 
#
## Automatically backup old preferences and start fresh on launch
# date +%y%m%d-%H%M | xargs -i mv ~/.local/share/feral-interactive/Medieval2 ~/.local/share/feral-interactive/Medieval2.{}.bak
#
## Show a version panel on start
# zenity --text-info --title "Medieval2 - Version Information" --filename version
# 
## Run with glc as the debugger for screen capture
# GLCFILE="Medieval2_$(date +%y%m%d-%H%M)"
# mkdir -p /tmp/ScreenCaptures && DEBUGGER="glc-capture -o /tmp/ScreenCaptures/${GLCFILE}.glc"

# Set the steam appid variable, this allows us to launch from test apps
# Important note: do not set SteamGameId, steam uses this to know that this is the same app it launched.
if [ "${SteamAppId}" != "4700" ]; then
	export SteamAppId="4700"
fi

# AMD drivers run faster with TCMalloc.
HAS_CATALYST="$(grep fglrx /proc/modules)"
if [ -n "${HAS_CATALYST}" ]; then
	LD_PRELOAD="../lib/i686/libtcmalloc_minimal.so:${LD_PRELOAD}"
	export LD_PRELOAD
fi

# cd to the game root
cd "$GAMEROOT/bin"

# Launch with the debugger if set
${DEBUGGER} "${GAMEROOT}/bin/Medieval2" $@
RESULT=$?

## DEBUGGING - Uncomment these lines for testing purposes
#
## Automatically convert the glc file to mp4, must be pared with command above, remove all steam library stuff first
# test -f "/tmp/ScreenCaptures/${GLCFILE}.glc" && LD_PRELOAD="" && LD_LIBRARY_PATH="" && glc-play "/tmp/ScreenCaptures/${GLCFILE}.glc" -o - -y 1 | ffmpeg -i - -y ~/.local/share/feral-interactive/Medieval2/${GLCFILE}.mp4

exit ${RESULT}

