#!/bin/bash

# figure out the absolute path to the script being run a bit
# non-obvious, the ${0%/*} pulls the path out of $0, cd's into the
# specified directory, then uses $PWD to figure out where that
# directory lives - and all this in a subshell, so we don't affect
# $PWD

GAMEROOT=$(cd "${0%/*}" && echo $PWD)/../..

if [[ $1 =~ -arch=([a-zA-Z1-9_]*) ]]; then
    ARCH="${BASH_REMATCH[1]}"
    shift
else
    ARCH=`uname -m`
fi

# setup steam runtime for x86 32 and 64bit versions.
if [ -z "$STEAM_RUNTIME" ]; then
    STEAM_RUNTIME="../../../ubuntu12_32/steam-runtime"
fi

export LD_LIBRARY_PATH="${GAMEROOT}/binaries/linux/$ARCH/":"${STEAM_RUNTIME}/amd64/lib/x86_64-linux-gnu:${STEAM_RUNTIME}/amd64/lib:${STEAM_RUNTIME}/amd64/usr/lib/x86_64-linux-gnu:${STEAM_RUNTIME}/amd64/usr/lib:${STEAM_RUNTIME}/i386/lib/i386-linux-gnu:${STEAM_RUNTIME}/i386/lib:${STEAM_RUNTIME}/i386/usr/lib/i386-linux-gnu:${STEAM_RUNTIME}/i386/usr/lib:${LD_LIBRARY_PATH}":$LD_LIBRARY_PATH

if [ -z $GAMEEXE ]; then
	  GAMEEXE=game.$ARCH
fi

ulimit -n 2048

# and launch the game
cd "$GAMEROOT"

STATUS=42
while [ $STATUS -eq 42 ]; do
	${DEBUGGER} "${GAMEROOT}/binaries/linux"/${GAMEEXE} $@
	STATUS=$?
done
exit $STATUS
