﻿# Notes:
# The batch exporter does NOT support have form of source control integration. If you feel like adding 
# source control integration be aware the the casing of the paths might be wrong and that this will
# need fixing BEFORE starting to add files and the like.

#import FxAnimation
import os
import string
import sys
import _winreg
import subprocess

def checkPath(path, errorMessage):
	if not os.path.exists(path):
		print errorMessage
		sys.exit(1)
	return

#
# Initialize script paths
#
assemblyPath = os.environ['ASSEMBLY_PATH']
checkPath(assemblyPath, "  Failed to locate assembly path: " + assemblyPath)
assemblyPath = os.path.normpath(assemblyPath)
print "  Assembly path: " + assemblyPath

#
# Load actor
#
actorPath = os.environ['ACTOR_FILENAME']
checkPath(actorPath, "  Failed to locate actor: " + actorPath)
print "  Loading actor: " + actorPath
FxStudio.issueCommand('loadActor -file ' + actorPath + ';')

#
# Batch process each folder
#
sourcePath = os.environ['SOUND_LOCALIZATION']
targetPath = os.environ['ANIMSET_LOCALIZATION']

print "  Source path: " + sourcePath
print "  Target path: " + targetPath

processFiles = os.environ['LIPSYNCGEN_FILES'];

for file in processFiles.split(';'):
	print "  File to process: " + file

	parentPath, groupName = string.rsplit(file, '\\', 1)

	inputFile = sourcePath + file + '.wav'
	outputFile = targetPath + file + '.animset'
	#print 'inputFile: ' + inputFile
	#print 'outputFile: ' + outputFile

	# Select language for analysis
	language = "USEnglish"
	if string.find(inputFile, "\\French\\") != -1:
		language = "French"
	elif string.find(inputFile, "\\German\\") != -1:
		language = "German"
	elif string.find(inputFile, "\\Italian\\") != -1:
		language = "Italian"
	elif string.find(inputFile, "\\Japanese\\") != -1:
		language = "Japanese"
	elif string.find(inputFile, "\\Korean\\") != -1:
		language = "Korean"
	elif string.find(inputFile, "\\Polish\\") != -1:
		# No FaceFX support for Polish
		language = "USEnglish"
	elif string.find(inputFile, "\\Spanish\\") != -1:
		language = "Spanish"
	#print 'language: ' + language
			
	analysisActor = os.environ['ANALYSIS_ACTOR']

	analyzeCommand = 'analyze -audio ' + '"' + inputFile + '"' + ' -overwrite -language ' + language + ' -analysisactor ' + analysisActor + ' -group ' + groupName + ';'
	exportCommand = 'animSet -export ' + groupName + ' -to "' + outputFile + '";'
	#print 'analyzeCommand: ' + analyzeCommand
	#print 'exportCommand: ' + exportCommand

	FxStudio.issueCommand(analyzeCommand)
	FxStudio.issueCommand(exportCommand)
