-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
-- PUBLIC FUNCTIONS
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
function SetCheckOutButtonEnable(enableButton)
	local checkoutButton = ui.getWindow("MainFrame|ToolBar|CheckOutNetwork")
	if (checkoutButton ~= nil) then
		checkoutButton:enable(enableButton)
	else
		print("Failed to get checkout button!\n")
	end
end

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
-- PRIVATE FUNCTIONS
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
local CheckOutNetworkButtonFunc = function()
	if(CheckOutFile(mcn.filename())) then
		SetCheckOutButtonEnable(false)
	end
end

local function AddUICheckOutNetworkButton()
	
	local checkoutButton = {}
	checkoutButton.name = "CheckOutNetwork"
	checkoutButton.imagePath = buildPath.."\\morpheme\\resources\\images\\IOI_Checkout_Network.xpm"
	checkoutButton.funcPointer = CheckOutNetworkButtonFunc
	checkoutButton.helpText = "Check out the currently open .mcn file from source control"
	checkoutButton.enabled = false
	
	AddUIButton(checkoutButton)
end	


AddUICheckOutNetworkButton()