function wait(secondsToWait)
	print("wait("..tostring(secondsToWait)..")")
	local startTime = os.time()
	local secondsPassed
	repeat
		local timeNow = os.time()
		secondsPassed = os.difftime(timeNow, startTime)
		print(tostring(timeNow).." | "..tostring(secondsPassed))
	until (secondsPassed >= secondsToWait)

end

-- Packs an uint32 to an ASCII string in big-endian format.
function uint32ToASCII(n)
	local n1 = math.mod(n, 0x100)
	local n2 = math.mod(math.floor(n / 0x100), 0x100)
	local n3 = math.mod(math.floor(n / 0x10000), 0x100)
	local n4 = math.mod(math.floor(n / 0x1000000), 0x100)
	--print("n: "..n.."\n".."n1: "..n1.."\n".."n2: "..n2.."\n".."n3: "..n3.."\n".."n4: "..n4.."\n")
	return string.char(n1, n2, n3, n4)
end

-- Copies a file from one location to another. Returns whether the operation was successful.
function CopyFile(sourceFilePath, destinationFilePath)
	local commandLine = string.format("copy \"%s\" \"%s\" /a /y", sourceFilePath, destinationFilePath)
	print("CopyFile("..sourceFilePath..", "..destinationFilePath..")")
	print("  Command line: "..commandLine)
	local copyExitCode = app.execute(commandLine, false, true)
	return copyExitCode == 0
end
