-- This is a script used to automatically generate rigs based on XMD animation files.
-- It is meant to be run from the command line and is thus not part of the general
-- Morpheme Connect script interface.

-- Workaround to avoid crash bug. See ticket #5528-6968361.
mcn.new(false)

-- Get the path to the XMD via a previously set environment variable
local animPath = os.getenv("ANIMPATH")
local trajBoneName = os.getenv("TRAJECTORYBONENAME")

-- The first rig will be crated in a temporary location. Due to a race condition we cannot use the final destination name. See ticket #5528-6968361.
local rigPath = string.format("%s\\temp\\TempRig", projectPath)
app.execute("mkdir "..quoteString(rigPath), false, true)
rigPath = string.format("%s\\Temp_Rig.xml", rigPath)

-- Create the rig with bogus indicies for the trajectory and root bone. The reason being that
-- we need an existing rig in order to extract this information. See ticket #5528-5545013.
local result = anim.createRig(animPath, rigPath, 0, 0)
mcn.commit("Rig initially created")

-- Read the path to rig currently set for the default animset
local oldRigPath = anim.getRigPath()

-- Reset the rig for the default anim set
anim.setRigPath(utils.macroizeString(rigPath))
mcn.commit("New rig set for default anim set")

-- Run through the bones to find the index of Bip01 and Ground
local rigBones = anim.getRigChannelNames()
local trajIndex = -1 -- Trajectory describes the general movemnt of the character/object. This bone should be called "Ground".
local rootIndex = -1 -- Root is the top most bone of the hierarchy of the character/object. If the rig does not contain a "Bip01" bone, then the "Ground" bone will be used instead.
for i, boneName in ipairs(rigBones) do
	-- Trajectory
	if(boneName == trajBoneName) then
		trajIndex = i - 1 -- Lua likes indices to start from 1
	end

	-- Root bone
	if(boneName == "Bip01") then
		rootIndex = i - 1 -- Lua likes indices to start from 1
	end
end

if(rootIndex < 0) then
	-- We did not find a "Bip01" bone, so assign the trajectory index as the root index instead.
	app.log("Bip01 bone not found. Assigning Ground bone index as root bone index.")
	rootIndex = trajIndex
end

-- Create the rig again this time supplying correct indicies for the root and trajectory channels
if(trajIndex > -1 and rootIndex > -1) then
	-- The final rig will be placed besides the corresponding animation file and will have the same name
	rigPath = string.gsub(animPath, nocase("XMD"), "xml")	
	result = anim.createRig(animPath, rigPath, rootIndex, trajIndex)
end

-- Put the rig path for the default animation set back to what it was
anim.setRigPath(utils.macroizeString(oldRigPath))
mcn.commit("Rig generation complete")