-- Copy/Paste function from NM startup script. We might want to customize this in the future
local function initAnimSource(node, animationTake)
	local filename = animationTake.filename
	local takename = animationTake.takename
	local clipStartFraction = animationTake.clipstartfraction
	local clipEndFraction = animationTake.clipendfraction
      
	local adjustedTake = {
		filename = utils.macroizeString(filename),
		takename = takename
	}
	--print("Initialising " .. node .. " : adjustedTake.filename = " .. filename .. "; adjustedTake.takename = " .. takename);
	setAttribute(node..".AnimationTake", adjustedTake)

	-- Initialise the clip start fraction attribute to 1.0 (the max).
	setAttribute(node..".ClipStartFraction", clipStartFraction)

	-- Initialise the clip start fraction attribute to 1.0 (the max).
	setAttribute(node..".ClipEndFraction", clipEndFraction)

	-- rename node to filename of fbx
	local dirname, shortname = splitPath(filename)
	local stripname = stripFilenameExtension(shortname)

	-- if node already exists, append a "_n" onto the end (the rename code will automatically
	-- convert "_1" to "_2", "_3" etc).
	local nodepath, nodename = splitNodePath(node)
	local testnode = stripname
	if nodepath then
		testnode = nodepath .. "|" .. stripname
	end
	
	if nodeExists(testnode) then
		stripname = stripname .. "_1"
	end
	
	rename(node, stripname)
end

local function addAnimLocations()
	
	-- To keep list sorted we have to wipe down animation locations and re-add them
	local existingLocations = anim.getAnimationLocations()
	while next(existingLocations) do
		remove = table.remove(existingLocations)
		anim.removeAnimationLocation(remove.source)
	end
	
	-- We cannot add animation locations if no animation directory has been specified
	if(animSourceDir == nil) then
		ReportError("Cannot add animation locations.\nPlease specify a default animation directory in settings.xml to facilitate this.")
		return
	end
	
	local dirQueue = {}
	local animLocations = {}
	table.insert(dirQueue, utils.demacroizeString(animSourceDir))

	-- process directories recursively
	while true do
		
		local currentDir = table.remove(dirQueue)
		if (currentDir == nil) then
			break
		end
		
		-- keep if dir contains xmd files
		local animFiles = app.enumerateFiles(currentDir , "*.XMD")
		if ( next(animFiles) ) then
			-- back-substitute $(RootDir)
			local addDir = string.gsub(currentDir, nocase(projectPath) , "$(RootDir)\\" )
			-- schedule for addition
			table.insert(animLocations, addDir)
		end
		
		-- append sub-dirs to queue
		local subDirs = app.enumerateDirectories( currentDir , "")
		for k, v in ipairs(subDirs) do
			table.insert(dirQueue, v)
		end
	end
	
	-- sort (reverse) the directory names and add
	table.sort(animLocations,function(a,b) return a>b end)
	while next(animLocations) do
		add = table.remove(animLocations)
		anim.addAnimationLocation(add)
	end
end


local function createControlParameter(name, type)
	if (not nodeExists("ControlParameters|" .. name)) then
		print("Parameter " .. name .. " not found. Creating...")
		local controlParamName = create("ControlParameter", type, name)
	end
end

local function deleteControlParameter(name)
	local fullPath = "ControlParameters|" .. name
	if (nodeExists(fullPath)) then
		print("Parameter " .. name .. " found. Deleting...")
		delete(fullPath)
	end
end

function addMandatoryControlParameters()
	
	-- Attempt to create missing control parameters. These must be created as floats for now, since integers as control parameters are currently not supported by NM. (Ticket #646)
	print("Creating missing mandatory control parameters...")

	-- Remove obsolete parameters
	deleteControlParameter("renderBoneDataIndex")
	deleteControlParameter("meshToRigMapDataIndex")
	deleteControlParameter("cutSequenceDataIndex")
	deleteControlParameter("soundResourceManagerIndex")
	deleteControlParameter("dataProviderIndex")
end

local function onNewFile(arg)
	print("onNewFile called "  .. tostring(arg))
  	addAnimLocations()
	addMandatoryControlParameters()
	SetDefaultRigInfo()
	SetCheckOutButtonEnable(false)
end

local function onOpenFileEnd(arg)
	print("onLoadFile called "  .. tostring(arg))
 	addAnimLocations()
	addMandatoryControlParameters()
	LoadRigPaths(arg)
	LoadAnimDataBasePath()
	LoadCharacterType()
end

-- Set preferences
mcn.writePreference("ProjectPath", rootDir)

if(animSourceDir ~= nil) then
	mcn.writePreference("DefaultSourceDirectories", animSourceDir)
end

if(markupDir ~= nil) then
	mcn.writePreference("DefaultMarkupDirectory", markupDir)
end

-- Important: We are fighting bad naming conventions here. The property we are is called DefaultAnimationExportRig,
-- but we are in fact using it as a preview rig. This is because in the NM world there is no distinction between export
-- and preview rigs. The DefaultAnimationExportRig is however the one being used in the anim browser until the user
-- changes  and thus we need to set the defaultPreviewRig instead.
if(defaultPreviewRig ~= nil) then
	mcn.writePreference("DefaultAnimationExportRig", defaultPreviewRig)
end

mcn.writePreference("CameraYUp", 0)

-- Setup custom runtime target and asset compiler paths
--local acExeName = string.format("%s\\morphemeAssetCompiler.exe", buildPath)
--local rtExeName = string.format("%s\\morphemeRuntimeTarget.exe", buildPath)
local acExeName = string.format("%s\\ioimorphemeassetcompiler.exe", buildPath)
local rtExeName = string.format("%s\\ioimorphemeRuntimeTarget.exe", buildPath)

-- Remove old entries
target.remove("PC G2")
target.remove("PC G2 Unmanaged")

target.add("PC G2", "G2 custom runtime target and asset compiler will be used by connect", acExeName, rtExeName, "127.0.0.1", 4567)
target.add("PC G2 Unmanaged", "G2 custom runtime target and asset compiler will be used by connect. The executables must be started by the user.", acExeName, "", "127.0.0.1", 4567)

-- Add string.match function not present in this version of Lua

function string.match(s, pattern, init)
	local internal_match = function (s,i1,i2, ...)
		if i1 ~= nil then
			if arg[1] ~= nil then
				return unpack(arg)
			else
				return s:sub(i1, i2)
			end
		else
			return nil
		end
	end

	return internal_match(s, s:find(pattern, init))
end


function nocase (s)
	s = string.gsub(s, "%a", 
		function (c)
			return string.format("[%s%s]", string.lower(c), string.upper(c))
		end
	)
	return s
end


-- Execute custom G2 scripts
local scriptsPath = buildPath.."/morpheme/scripts/"
executeSingleScript(scriptsPath.."common/utility.lua")
JSON = (loadfile(scriptsPath.."common/json.lua"))()

-- Load custom G2 manifest and register custom node types
executeSingleScript(scriptsPath.."manifest/base.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIAnim.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIBlend2ForwardEvents.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIChildNetwork.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOICutSequence.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIVariation.lua")
executeSingleScript(scriptsPath.."manifest/nodes/HeadLookNoEvents.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOILookatNode.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOISelectNode.lua")
executeSingleScript(scriptsPath.."manifest/nodes/TransitionSelect.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIDeltaAnim.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIDeltaAnimMatchEvents.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIHeadController.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIFilterTransforms.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIModifyBoneAlpha.lua")
executeSingleScript(scriptsPath.."manifest/transitions/IOITransit.lua")
executeSingleScript(scriptsPath.."manifest/transitions/IOIWildCardTransit.lua")
executeSingleScript(scriptsPath.."manifest/transitions/IOIWildCardTransitMatchEvents.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIPelvisOffset.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIMirror.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIMirrorMatchEvents.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIBlend2AndReTarget.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIPartialMirrorAim.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOISelectiveFeatherBlend.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOISelectiveFeatherBlendForwardEvents.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIGroundRotation.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIScaleAnim.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOISneakModifier.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOITranslationScale.lua")
executeSingleScript(scriptsPath.."manifest/nodes/SelectNodeMatchEvents.lua")
executeSingleScript(scriptsPath.."manifest/nodes/OperatorFloat.lua")
executeSingleScript(scriptsPath.."manifest/nodes/IOIParametricBlendNMatchEvents.lua")

-- IOI PATCH: Remove once Morpheme ver. 1.3.4 is integrated
executeSingleScript(scriptsPath.."manifest/nodes/PlaySpeedModifier.lua")
executeSingleScript(scriptsPath.."manifest/nodes/PlaySpeedModifierMatchEvents.lua")

-- Load custom G2 manifest and register custom transit condition types
executeSingleScript(scriptsPath.."manifest/conditions/PercentageThroughSubtransition.lua")
--executeSingleScript(scriptsPath.."editors/IOISelectiveFeatherBlend_AE.lua")
--executeSingleScript(scriptsPath.."editors/IOISelectiveFeatherBlendForwardEvents_AE.lua")

-- Until we get a better system for this implemented we are forced to executed every single script manuallly in a particular order.
executeSingleScript(scriptsPath.."resource_server.lua")
executeSingleScript(scriptsPath.."ui/dialogs.lua")
executeSingleScript(scriptsPath.."custom_data.lua")
executeSingleScript(scriptsPath.."character_type.lua")
executeSingleScript(scriptsPath.."set_rig_info.lua")
executeSingleScript(scriptsPath.."ui/g2ui.lua")
executeSingleScript(scriptsPath.."sourcecontrol.lua")
executeSingleScript(scriptsPath.."checkout_network.lua")
executeSingleScript(scriptsPath.."export_ioi.lua")

-- Register custom animation source type
unregisterAnimationFileType("fbx")
unregisterAnimationFileType("xmd")
registerAnimationFileType("xmd", "IOIAnim", initAnimSource)

-- Register event handlers
registerEventHandler("mcFileNewEnd", onNewFile)
registerEventHandler("mcFileOpenEnd", onOpenFileEnd)

target.select("PC G2")
--target.select("PC G2 Unmanaged")

