registerCondition("DiscreteEventTriggered",
  {
    id = generateNamespacedId(idNamespaces.NaturalMotion, 602),
    attributes = 
    {
      ["EventUserTypeID"] = {type = "int", value = 0},
      ["WeightGreaterThan"] = {type = "float", value = 0.0, min = 0.0, max = 1.0},
      ["OrEqual"] = {type = "bool", value = true},
    },
    
    serialize = function(condition, Stream)
      local evtUserTypeID = getAttribute(condition, "EventUserTypeID")
      local weightThreshold = getAttribute(condition, "WeightGreaterThan")
      local orEqual = getAttribute(condition, "OrEqual")
      
      Stream:writeInt(evtUserTypeID, "EventUserTypeID")
      Stream:writeFloat(weightThreshold, "WeightGreaterThan")
      Stream:writeBool(orEqual, "OrEqual")
    end,
    
    validate = function(condition)
      -- the min condition on the attribute ensures this is valid
      return true
    end,
  }
)