registerCondition(
	"PercentThroughSubtransition", 
	{
		id = generateNamespacedId(idNamespaces.IOI, IOITransitConditionTypeNumbers.TransitConditionTypePercentageThroughSubtransition),
		attributes = 
		{
			["TriggerPercent"] = {type = "float", value = 1.00, min = 0.0, max = 1.0},
			["SubState"] = {type = "string", value = ""},					-- sub-state to observe
			["UseTransitionSource"] = {type = "bool", value = false},		-- this flag indicates we want to observe transitions starting from specified sub-state
			["LessThan"] = {type = "bool", value = false},
		},
	    
		serialize = function(condition, Stream)
			local versionNumber = 1
			local triggerPos = getAttribute(condition, "TriggerPercent")
			local subState = getAttribute(condition, "SubState")
			local useTransitionSource = getAttribute(condition, "UseTransitionSource")
			local lessThan = getAttribute(condition, "LessThan")
			
			Stream:writeInt(versionNumber, "VersionNumber")
			Stream:writeFloat(triggerPos, "TriggerPercent")
			Stream:writeInt(string.len(subState), "SubState_Length")
			Stream:writeString(subState, "SubState")
			Stream:writeBool(useTransitionSource, "UseTransitionSource")
			Stream:writeBool(lessThan, "LessThan")
		end,
	    
		validate = function(condition)
			
			// Get the name of the transition this condition belongs to.
			local transition = getParent(condition)
			local sourceNodesTable = listConnections{Object= transition, Upstream = true, Downstream = false, ResolveReferences = true}
			local sourceNodeName = sourceNodesTable[1]
			
			// Ensure that the sub state we are monitoring actually exists
			local subState = getAttribute(condition, "SubState")
			
			local bFoundSubState = false
			local sourceChildren = listChildren(sourceNodeName)
			for k,v  in sourceChildren do
				if(string.find(v, subState) ~= nil) then
					bFoundSubState = true
					break
				end
			end
			
			if(not bFoundSubState) then
				return false, ("PrecentageThroughSubTransition condition '"..condition.."' refres to an invalid sub state name: ".."'"..subState.."'. Note that names are CASE SENSITIVE")
			end
			
			-- the min and max condition on the TriggerPosition ensures this is valid
			return true
		end,
	}
)