------------------------------------------------------------------------------------------------------------------------
-- BlendN node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("BlendN",
  {
    helptext = "Blends N animation streams together",
    group = "Blends",
    image = "BlendN.png",
    id = generateNamespacedId(idNamespaces.NaturalMotion, 108),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Source0"] = { 
                       input = true, 
                       array = false,
                       interfaces = {"Transforms", "Time"},
                     },
                     
      ["Source1"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },
  
      ["Source2"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },
                     
      ["Source3"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },
                     
      ["Source4"] = {
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },
                     
      ["Source5"] = {
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },
                     
      ["Source6"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },
                     
      ["Source7"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },

      ["Source8"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },

      ["Source9"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },

      ["Source10"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },

      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms", "Time"}, 
                   },
    },
    
    dataPins = 
    {
       ["Weight"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
    },
    
    pinOrder =
    {
      "Source0",
      "Source1",
      "Source2",
      "Source3",
      "Source4",
      "Source5",
      "Source6",
      "Source7",
      "Source8",
      "Source9",
      "Source10",
      "Result",
      "Weight"
    },
    
    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      { name = "Loop", type = "bool", value = true },
      { name = "SphericallyInterpolateTrajectoryPosition", type = "bool", value = false },
      { name = "BlendWeights", type = "floatArray" },
      { name = "BranchOptimization", type = "bool", value = true },
      { name = "Source0IgnoreEventWeight", type = "bool", value = false },
      { name = "Source1IgnoreEventWeight", type = "bool", value = false },
      { name = "UpdateWeightingOnce", type = "bool", value = false},
    },
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local connectedNodeCount = 0
      local connectedPinCount = 0
      local connectedIds = {} 
      local pinWeight = {} 
            
      for currentPin = 0, 10 do
        local pinName = (node .. ".Source" .. currentPin)
        if isConnected{SourcePin  =  pinName, ResolveReferences = true} then 
          connectedPinCount = connectedPinCount + 1
          connectedIds[currentPin] = getConnectedNodeID(pinName)
        else 
          break
        end
      end
        
      -- if there is a mismatch between the number of pins, just re-initialise
      -- to a linear interpolation, else use pin weights directly
      local blendWeights = getAttribute(node, "BlendWeights")
      local numBlendWeights = table.getn(blendWeights)
      if numBlendWeights ~= connectedPinCount then
        for i = 1, connectedPinCount do
          local value = (i - 1) / (connectedPinCount - 1)
          pinWeight[i] = value
        end
      else
        for i, v in ipairs(blendWeights) do
          pinWeight[i] = v
        end
      end  
        
      local numPinWeights = table.getn(pinWeight)

      local versionNumber = 2
      Stream:writeInt(versionNumber, "versionNumber")
      
      -- do we want this nodes output to loop. 
      local loop = getAttribute(node, "Loop")
      Stream:writeBool(loop, "Loop")
      
      -- do we want this node to spherically interpolate the input delta trajectory translations.
      local sphericalTrajPos = getAttribute(node, "SphericallyInterpolateTrajectoryPosition")
      Stream:writeBool(sphericalTrajPos, "SphericallyInterpolateTrajectoryPosition")

	  -- do we want this node to perform blend tree optimizations?
      local branchOptimization = getAttribute(node, "BranchOptimization")
      Stream:writeBool(branchOptimization, "BranchOptimization")
      
      -- Do we want to ignore blend weights when sampling events?
      local source0IgnoreEventWeight = getAttribute(node, "Source0IgnoreEventWeight")
      local source1IgnoreEventWeight = getAttribute(node, "Source1IgnoreEventWeight")
      Stream:writeBool(source0IgnoreEventWeight, "Source0IgnoreEventWeight")
      Stream:writeBool(source1IgnoreEventWeight, "Source1IgnoreEventWeight")
      
      local UpdateWeightingOnce = getAttribute(node, "UpdateWeightingOnce")
      Stream:writeBool(UpdateWeightingOnce, "UpdateWeightingOnce")
            
      -- next write out the id of the node connected to the weight parameter
      if isConnected{SourcePin  = (node .. ".Weight"), ResolveReferences = true} then 
        local wId = getConnectedNodeID( (node .. ".Weight") ) 
        if wId ~= nil then
          Stream:writeUInt(wId, "IDConnectedToWeight")
        else
          Stream:writeUInt(-1, "ConnectedToInvalidNode")
        end
      else
        Stream:writeUInt(-1, "ConnectedToInvalidNode") -- treat 0xFFFFFFFF as invalid
      end
      
      -- now write out the number of connected pins
      Stream:writeInt(connectedPinCount)
      
      -- finally write connectedPinCount pairs of runtime id and pin weight
      for currentPin = 0, (connectedPinCount - 1) do 
        Stream:writeInt(connectedIds[currentPin], "ConnectedNodeID")
        Stream:writeFloat(pinWeight[currentPin + 1], "ConnectionWeight")
      end        
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      local connectedPinCount = 0
      local pinsAllowed = true
      local error = false
      local warn = false
      local errorMessage = ""
      local warnMessage = ""
      
      for currentPin = 0, 10 do
        local pinName = (node .. ".Source" .. currentPin)
        if isConnected{SourcePin  = pinName, ResolveReferences = true} then 
          if pinsAllowed then
           connectedPinCount = connectedPinCount + 1
          else
           error = true
           errorMessage = "The pins on Blend N node " .. node .. " are not connected consecutively. Ensure that there is not a gap between connections" 
          end

          local nodesConnected = listConnections{Object = pinName, ResolveReferences = true}
          if isValid(nodesConnected[1]) ~= true then
           error = true
           errorMessage = "The pins on Blend N node " .. node .. " are not connected to valid nodes" 
          end
        else 
          pinsAllowed = false
        end
      end
      
      if not(error or warn) then 
        if connectedPinCount < 2 then
          error = true
          errorMessage = "The Blend N node " .. node .. " requires at least two connections"
        end
      end

      if isConnected{SourcePin  = (node..".Weight"), ResolveReferences = true}  then
        local nodesConnectedToWeight = listConnections{Object = (node..".Weight"), ResolveReferences = true}
        local nodeWeight = nodesConnectedToWeight[1]
        if isValid(nodeWeight) ~= true then
			    warn = true
			    warnMessage = node .. " has no valid input to weight pin, default to a value of 0"
        end
      else 
		    warn = true
		    warnMessage = node .. " has no input to weight pin, default to a value of 0"
      end
      
      -- Validate blend weight values.
      local blendWeights = getAttribute(node, "BlendWeights")
      local numBlendWeights = table.getn(blendWeights)
      local pinWeight = {}
      for i, v in ipairs(blendWeights) do
          pinWeight[i] = v
          if i > 1 then
            if pinWeight[i] < pinWeight[i - 1] then
              error = true
              errorMessage = "Pin weights must be specified with increasing value on the Blend N node " .. node
            end
          end
      end  
      
      -- verify that the node is correctly setup
      if error then
        return nil, errorMessage
      end
      if warn then
		    return true, warnMessage
      end
      return true
    end,
          
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local unionOfResults = {} 
      for currentPin = 0, 10 do
        local pinName = (node .. ".Source" .. currentPin)
        if isConnected{SourcePin  = pinName, ResolveReferences = true} then 
          local sourceTable = listConnections{Object =  pinName, ResolveReferences = true}
          local sourceNode = sourceTable[1]
          local curChannels = anim.getTransformChannels(sourceNode)
          if firstPin then
            unionOfResults = curChannels
          else
            unionOfResults = setUnion(unionOfResults, curChannels)
          end
        else 
          break
        end
      end
      return unionOfResults
    end,  

    --------------------------------------------------------------------------------------------------------------------
    onPinConnected = rebuildBlendWeights,
    
    --------------------------------------------------------------------------------------------------------------------
    onPinDisconnected = rebuildBlendWeights
  }
)

------------------------------------------------------------------------------------------------------------------------
-- End of BlendN node definition.
------------------------------------------------------------------------------------------------------------------------

