------------------------------------------------------------------------------------------------------------------------
-- SpineIK node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("SpineIK",
  {
    helptext = "SpineIK: points chosen end effector at target along a given pointing direction",
    group = "Utilities",
    image = "HeadLook.png",
    id = generateNamespacedId(idNamespaces.NaturalMotion, 122),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Source"] = {
                       input = true, 
                       array = false,
                       interfaces = {"Transforms", "Time", "Events"},
                     },
                     
      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms", "Time", "Events"}, 
                   },
    },
    
    dataPins = 
    {
        ["Target"] = {
                      input = true, 
                      array = false, 
                      type = "vector3", 
                    },
        ["PointingJointAxis"] = {
                      input = true, 
                      array = false, 
                      type = "vector3", 
                    },
        ["PointintJointID"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
        ["BlendWeight"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
    },
    
    pinOrder = {"Source", "Result", "Target", "PointingJointAxis", "PointintJointID", "BlendWeight"},
    
    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      { name = "EndJointIndex", type = "int", value = 0, perAnimSet = true },
      { name = "RootJointIndex", type = "int", value = 0, perAnimSet = true },
      { name = "PointingJointIndex", type = "int", value = 0, perAnimSet = true },
      { name = "PointingJointAxisX", type = "float", value = 0 },
      { name = "PointingJointAxisY", type = "float", value = 1 },
      { name = "PointingJointAxisZ", type = "float", value = 0 },
      { name = "Bias", type = "float", value = 1 },
      { name = "UpdateTargetByDeltas", type = "bool", value = false },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local inputNodeID = -1
      local targetNodeID = -1
      local pointingJointAxisNodeID = -1
      local pointintJointIDNodeID = -1
      local blendWeightNodeID = -1
      
      if isConnected{SourcePin = (node .. ".Source") , ResolveReferences = true} then 
        inputNodeID = getConnectedNodeID(node, "Source")
      end
      
      if isConnected{SourcePin = (node .. ".Target") , ResolveReferences = true} then 
        targetNodeID = getConnectedNodeID(node, "Target")
      end
      
      if isConnected{SourcePin = (node .. ".PointingJointAxis") , ResolveReferences = true} then 
        pointingJointAxisNodeID = getConnectedNodeID(node, "PointingJointAxis")
      end

      if isConnected{SourcePin = (node .. ".PointintJointID") , ResolveReferences = true} then 
        pointintJointIDNodeID = getConnectedNodeID(node, "PointintJointID")
      end

      if isConnected{SourcePin = (node .. ".BlendWeight") , ResolveReferences = true} then 
        blendWeightNodeID = getConnectedNodeID(node, "BlendWeight")
      end
      
      local animSets = listAnimSets()
      local numAnimSets = table.getn(animSets)

      Stream:writeUInt(numAnimSets, "NumAnimSets")
      
      Stream:writeUInt(inputNodeID, "InputNodeID")
      Stream:writeUInt(targetNodeID, "TargetNodeID")
      Stream:writeUInt(pointingJointAxisNodeID, "PointingJointAxisNodeID")
      Stream:writeUInt(pointintJointIDNodeID, "PointintJointIDNodeID")
      Stream:writeUInt(blendWeightNodeID, "BlendWeightNodeID")

      local pjAxisX = getAttribute(node, "PointingJointAxisX")
      Stream:writeFloat(pjAxisX)
      local pjAxisY = getAttribute(node, "PointingJointAxisY")
      Stream:writeFloat(pjAxisY)
      local pjAxisZ = getAttribute(node, "PointingJointAxisZ")
      Stream:writeFloat(pjAxisZ)
           
      local bias = getAttribute(node, "Bias")
      Stream:writeFloat(bias)
      
      local updateTargetByDeltas = getAttribute(node, "UpdateTargetByDeltas")
      Stream:writeBool(updateTargetByDeltas)
      
      for asIdx, asVal in animSets do
        local endJointIndex = getAttribute(node, "EndJointIndex", asVal)
        Stream:writeUInt(endJointIndex)
      
        local rootJointIndex = getAttribute(node, "RootJointIndex", asVal)
        Stream:writeUInt(rootJointIndex)

		local pointingJointIndex = getAttribute(node, "PointingJointIndex", asVal)
		Stream:writeUInt(pointingJointIndex)
      end
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
    
      local inputNode
      
      -- Validate connections
      if isConnected{SourcePin = (node .. ".Source") , ResolveReferences = true} then
        local nodesConnected = listConnections{Object = (node .. ".Source") , ResolveReferences = true}
        inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, ("HeadLook node " .. node .. " requires a valid input node")
        end
        
      else 
        return nil, ("HeadLook node " .. node .. " is missing a required connection to Source")
      end
          
      if isConnected{SourcePin = (node .. ".Target") , ResolveReferences = true} then
        local nodesConnected = listConnections{Object = (node .. ".Target") , ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, ("HeadLook node " .. node .. " requires a valid Look-At Target")
        end        
      else 
        return nil, ("HeadLook node " .. node .. " is missing a required connection to Target")
      end

      if isConnected{SourcePin = (node .. ".BlendWeight") , ResolveReferences = true} then
        local nodesConnected = listConnections{Object = (node .. ".BlendWeight") , ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, ("HeadLook node " .. node .. " requires a valid Blend Weight")
        end
      end
      return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected{SourcePin = (node .. ".Source"), ResolveReferences = true} then 
        local SourceTable = listConnections{Object = (node .. ".Source") , ResolveReferences = true}
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
    end,

  }

)

------------------------------------------------------------------------------------------------------------------------
-- End of SpineIK node definition.
------------------------------------------------------------------------------------------------------------------------







