------------------------------------------------------------------------------------------------------------------------
-- Blend2 node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("IOIBlend2AndReTarget",
  {
    helptext = "Blends two animation streams together and (optiaonally) retarget end effectors to position and orientation given by Source0's anmation stream",
    group = "Blends",
    image = "IOIBlend2AndRetarget.png",    
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOIBlend2AndReTarget),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Source0"] = {
                       input = true, 
                       array = false,
                       interfaces = {"Transforms", "Time"},
                     },
                     
      ["Source1"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },
      
      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms", "Time"}, 
                   },
    },
    
    dataPins = 
    {
       ["Weight"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
    },
    
    pinOrder = {"Source0", "Source1", "Result", "Weight"},
    
    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      { name = "Loop", type = "bool", value = true },
      { name = "UseSource1Additively", type = "bool", value = true},
      { name = "AdditiveBlendAttitude", type = "bool", value = false },
      { name = "AdditiveBlendPosition", type = "bool", value = false },
      { name = "SphericallyInterpolateTrajectoryPosition", type = "bool", value = false },
      { name = "ReTargetRightHandToSource0", type = "bool", value = false },
      { name = "ReTargetLeftHandToSource0", type = "bool", value = false },
      { name = "ReTargetRightHandToSource1", type = "bool", value = false },
      { name = "ReTargetLeftHandToSource1", type = "bool", value = false },
      { name = "ReTargetRightFootToSource0", type = "bool", value = false },
      { name = "ReTargetLeftFootToSource0", type = "bool", value = false },
      { name = "ReTargetRightFootToSource1", type = "bool", value = false },
      { name = "ReTargetLeftFootToSource1", type = "bool", value = false },
      { name = "KeepLeftHandRelativeToRightFromSource0", type = "bool", value = false },
      { name = "KeepRightHandRelativeToLeftFromSource0", type = "bool", value = false },
      { name = "KeepLeftHandRelativeToRightFromSource1", type = "bool", value = false },
      { name = "KeepRightHandRelativeToLeftFromSource1", type = "bool", value = false },
      { name = "UpdateWeightingOnce", type = "bool", value = false},
    },
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local node0 = -1
      local node1 = -1
      local weightNodeID = -1
      local loop = getAttribute(node, "Loop")
      local useSource1Additively = getAttribute(node, "UseSource1Additively")
      local additiveAtt = getAttribute(node, "AdditiveBlendAttitude")
      local additivePos = getAttribute(node, "AdditiveBlendPosition")
      local sphericalTrajPos = getAttribute(node, "SphericallyInterpolateTrajectoryPosition")
      local b0 = getAttribute(node, "ReTargetRightHandToSource0")
      local b1 = getAttribute(node, "ReTargetLeftHandToSource0")
      local b2 = getAttribute(node, "ReTargetRightHandToSource1")
      local b3 = getAttribute(node, "ReTargetLeftHandToSource1")
      local b4 = getAttribute(node, "ReTargetRightFootToSource0")
      local b5 = getAttribute(node, "ReTargetLeftFootToSource0")
      local b6 = getAttribute(node, "ReTargetRightFootToSource1")
      local b7 = getAttribute(node, "ReTargetLeftFootToSource1")
      
      local b8 = getAttribute(node, "KeepLeftHandRelativeToRightFromSource0")
      local b9 = getAttribute(node, "KeepRightHandRelativeToLeftFromSource0")
      local b10 = getAttribute(node, "KeepLeftHandRelativeToRightFromSource1")
      local b11 = getAttribute(node, "KeepRightHandRelativeToLeftFromSource1")
      
      local UpdateWeightingOnce = getAttribute(node, "UpdateWeightingOnce")
               
      if isConnected{SourcePin  =(node .. ".Source0") , ResolveReferences = true} then 
        node0 = getConnectedNodeID(node, "Source0")
      end
      if isConnected{SourcePin  = (node .. ".Source1"), ResolveReferences = true} then 
        node1 = getConnectedNodeID(node, "Source1")
      end
      if isConnected{SourcePin  = (node .. ".Weight"), ResolveReferences = true} then 
        weightNodeID = getConnectedNodeID(node, "Weight")
      end
      
      local versionNumber = 3
      Stream:writeInt(versionNumber, "versionNumber")
      
      Stream:writeUInt(node0, "Source0ConnectedNodeID")
      Stream:writeUInt(node1, "Source1ConnectedNodeID")
      Stream:writeUInt(weightNodeID, "IDConnectedToWeight")
      Stream:writeBool(loop, "Loop")
      Stream:writeBool(useSource1Additively, "UseSource1Additively")
      Stream:writeBool(additiveAtt, "AdditiveBlendAttitude")
      Stream:writeBool(additivePos, "AdditiveBlendPosition")
      Stream:writeBool(sphericalTrajPos, "SphericallyInterpolateTrajectoryPosition")
      
      Stream:writeBool(b0, "ReTargetRightHandToSource0")
      Stream:writeBool(b1, "ReTargetLeftHandToSource0")
      Stream:writeBool(b2, "ReTargetRightHandToSource1")
      Stream:writeBool(b3, "ReTargetLeftHandToSource1")
      Stream:writeBool(b4, "ReTargetRightFootToSource0")
      Stream:writeBool(b5, "ReTargetLeftFootToSource0")
      Stream:writeBool(b6, "ReTargetRightFootToSource1")
      Stream:writeBool(b7, "ReTargetLeftFootToSource1")
      
      Stream:writeBool(b8, "KeepLeftHandRelativeToRightFromSource0")
      Stream:writeBool(b9, "KeepRightHandRelativeToLeftFromSource0")
      Stream:writeBool(b10, "KeepLeftHandRelativeToRightFromSource1")
      Stream:writeBool(b11, "KeepRightHandRelativeToLeftFromSource1")
      
      Stream:writeBool(UpdateWeightingOnce, "UpdateWeightingOnce")
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected{SourcePin  = (node..".Source0"), ResolveReferences = true} and isConnected{SourcePin  = (node..".Source1"), ResolveReferences = true} then
        local nodesConnectedTo0 = listConnections{Object = (node..".Source0"), ResolveReferences = true}
        local nodesConnectedTo1 = listConnections{Object = (node..".Source1"), ResolveReferences = true}
        local node0 = nodesConnectedTo0[1]
        local node1 = nodesConnectedTo1[1]
        if isValid(node0) ~= true or isValid(node1) ~= true then
          return nil, "Blend 2 requires two valid input nodes"
        end
        
      else 
        return nil, ("Blend 2 node " .. node .. " is missing a required connection to Source0 and/or Source1")
      end
      
      if isConnected{SourcePin  = (node..".Weight"), ResolveReferences = true} then
        local nodesConnectedToWeight = listConnections{Object = (node..".Weight"), ResolveReferences = true}
        local nodeWeight = nodesConnectedToWeight[1]
        if isValid(nodeWeight) ~= true then
	        return true, (node .. " has no valid input to weight pin, default to a value of 0")
        end
      else 
        return true, (node .. " has no input to weight pin, default to a value of 0")
      end
      
      return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local node0Channels = {} 
      local node1Channels = {} 
      if isConnected{SourcePin  = (node .. ".Source0"), ResolveReferences = true} then 
        local Source0Table = listConnections{Object = (node .. ".Source0") , ResolveReferences = true}
        local NodeConnectedTo0 = Source0Table[1]
        node0Channels = anim.getTransformChannels(NodeConnectedTo0)
      end

      if isConnected{SourcePin  = (node .. ".Source1"), ResolveReferences = true} then 
        local Source1Table = listConnections{Object = (node .. ".Source1") , ResolveReferences = true}
        local NodeConnectedTo1 = Source1Table[1]
        node1Channels = anim.getTransformChannels(NodeConnectedTo1)
      end

      local resultChannels = setUnion(node0Channels, node1Channels)
      return resultChannels
    end,

  }

)

------------------------------------------------------------------------------------------------------------------------
-- End of IOIBlend2AndReTarget node definition.
------------------------------------------------------------------------------------------------------------------------





