------------------------------------------------------------------------------------------------------------------------
-- Blend2 node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("Blend2ForwardEvents",
  {
    helptext = "Blends two animation streams together but matches event from source 0 only",
    group = "Blends",
    image = "Blend2ForwardEvents.png",
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOIBlend2ForwardEvents),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Source0"] = {
                       input = true, 
                       array = false,
                       interfaces = {"Transforms", "Time", "Events"},
                     },
                     
      ["Source1"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },
      
      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms", "Time", "Events"}, 
                   },
    },
    
    dataPins = 
    {
       ["Weight"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
    },
    
    pinOrder = {"Source0", "Source1", "Result", "Weight"},
    
    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      { name = "Loop", type = "bool", value = true },
      { name = "UseSource1Additively", type = "bool", value = true},
      { name = "AdditiveBlendAttitude", type = "bool", value = false },
      { name = "AdditiveBlendPosition", type = "bool", value = false },
      { name = "SphericallyInterpolateTrajectoryPosition", type = "bool", value = false },
      { name = "BranchOptimization", type = "bool", value = true },
      { name = "UseGlobalDeltaTime", type = "bool", value = true },
      { name = "Source0IgnoreEventWeight", type = "bool", value = false },
      { name = "Source1IgnoreEventWeight", type = "bool", value = false },
      { name = "UpdateWeightingOnce", type = "bool", value = false},
      { name = "Source0IsFullBodyAnimation", type = "bool", value = true},
    },
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local node0 = -1
      local node1 = -1
      local weightNodeID = -1
      local loop = getAttribute(node, "Loop")
      local useSource1Additively = getAttribute(node, "UseSource1Additively")
      local additiveAtt = getAttribute(node, "AdditiveBlendAttitude")
      local additivePos = getAttribute(node, "AdditiveBlendPosition")
      local sphericalTrajPos = getAttribute(node, "SphericallyInterpolateTrajectoryPosition")
      local branchOptimization = getAttribute(node, "BranchOptimization")
      local useGlobalDeltaTime = getAttribute(node, "UseGlobalDeltaTime")
      local source0IgnoreEventWeight = getAttribute(node, "Source0IgnoreEventWeight")
      local source1IgnoreEventWeight = getAttribute(node, "Source1IgnoreEventWeight")
      local UpdateWeightingOnce = getAttribute(node, "UpdateWeightingOnce")
      local Source0IsFullBodyAnimation = getAttribute(node, "Source0IsFullBodyAnimation")
      
      if isConnected{SourcePin  =(node .. ".Source0") , ResolveReferences = true} then 
        node0 = getConnectedNodeID(node, "Source0")
      end
      if isConnected{SourcePin  = (node .. ".Source1"), ResolveReferences = true} then 
        node1 = getConnectedNodeID(node, "Source1")
      end
      if isConnected{SourcePin  = (node .. ".Weight"), ResolveReferences = true} then 
        weightNodeID = getConnectedNodeID(node, "Weight")
      end
      
      local versionNumber = 4
      Stream:writeInt(versionNumber, "versionNumber")
      
      Stream:writeUInt(node0, "Source0ConnectedNodeID")
      Stream:writeUInt(node1, "Source1ConnectedNodeID")
      Stream:writeUInt(weightNodeID, "IDConnectedToWeight")
      Stream:writeBool(loop, "Loop")
      Stream:writeBool(useSource1Additively, "UseSource1Additively")
      Stream:writeBool(additiveAtt, "AdditiveBlendAttitude")
      Stream:writeBool(additivePos, "AdditiveBlendPosition")
      Stream:writeBool(sphericalTrajPos, "SphericallyInterpolateTrajectoryPosition")
      Stream:writeBool(branchOptimization, "BranchOptimization")
      Stream:writeBool(source0IgnoreEventWeight, "Source0IgnoreEventWeight")
      Stream:writeBool(source1IgnoreEventWeight, "Source1IgnoreEventWeight")
      Stream:writeBool(useGlobalDeltaTime, "UseGlobalDeltaTime")
      Stream:writeBool(UpdateWeightingOnce, "UpdateWeightingOnce")
      Stream:writeBool(Source0IsFullBodyAnimation, "Source0IsFullBodyAnimation")
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected{SourcePin  = (node..".Source0"), ResolveReferences = true} and isConnected{SourcePin  = (node..".Source1"), ResolveReferences = true} then
        local nodesConnectedTo0 = listConnections{Object = (node..".Source0"), ResolveReferences = true}
        local nodesConnectedTo1 = listConnections{Object = (node..".Source1"), ResolveReferences = true}
        local node0 = nodesConnectedTo0[1]
        local node1 = nodesConnectedTo1[1]
        if isValid(node0) ~= true or isValid(node1) ~= true then
          return nil, "Blend 2 requires two valid input nodes"
        end
        
      else 
        return nil, ("Blend 2 node " .. node .. " is missing a required connection to Source0 and/or Source1")
      end
      
      if isConnected{SourcePin  = (node..".Weight"), ResolveReferences = true} then
        local nodesConnectedToWeight = listConnections{Object = (node..".Weight"), ResolveReferences = true}
        local nodeWeight = nodesConnectedToWeight[1]
        if isValid(nodeWeight) ~= true then
	        return true, (node .. " has no valid input to weight pin, default to a value of 0")
        end
      else 
        return true, (node .. " has no input to weight pin, default to a value of 0")
      end
      
      return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local node0Channels = {} 
      local node1Channels = {} 
      if isConnected{SourcePin  = (node .. ".Source0"), ResolveReferences = true} then 
        local Source0Table = listConnections{Object = (node .. ".Source0") , ResolveReferences = true}
        local NodeConnectedTo0 = Source0Table[1]
        node0Channels = anim.getTransformChannels(NodeConnectedTo0)
      end

      if isConnected{SourcePin  = (node .. ".Source1"), ResolveReferences = true} then 
        local Source1Table = listConnections{Object = (node .. ".Source1") , ResolveReferences = true}
        local NodeConnectedTo1 = Source1Table[1]
        node1Channels = anim.getTransformChannels(NodeConnectedTo1)
      end

      local resultChannels = setUnion(node0Channels, node1Channels)
      return resultChannels
    end,

  }

)

------------------------------------------------------------------------------------------------------------------------
-- End of Blend2 node definition.
------------------------------------------------------------------------------------------------------------------------







