registerNode("IOIChildNetwork",
{
	helptext = "The child network node functions like a dynamic network reference",
	group = "Utilities",
	image = "IOIChildNetwork.png",
	id = generateNamespacedId(idNamespaces.G2, G2NodeTypeNumbers.NodeTypeIOIChildNetwork),
	--------------------------------------------------------------------------------------------------------------------
    
	functionPins = 
	{
		["Result"] = { 
						input = false,
						array = false,
						interfaces = {"Transforms", "Time", "Events"},
					},
	},
	
	attributes =
	{
	},
	
	--------------------------------------------------------------------------------------------------------------------
	serialize = function(node, Stream)
		-- Write a node version number as the first bit of data. This can then be used to make
		-- the node definition creator backwards compatible with earlier node versions. Thus we should be able
		-- submit new versions of our animation node without breaking the Gfx build if we keep the node definition
		-- creator backwards compatible.
		
		-- Custom data specific to the IOI anim source node:
		Stream:writeInt(3, "ChildNetworkNodeVersion");
		
	end,
    
	--------------------------------------------------------------------------------------------------------------------
	validate = function(node)
		local valid = true
		local errorMessage = ""
	
		if(valid) then
			return true
		else
			return nil, errorMessage 
		end
	end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
		-- This is expected to output a table containing all the rig indices that this nodes outputs transforms for
		-- Since we cannot know this information at export time, we simply return an empty set. We cannot guarantee
		-- at this point that any bones will be output.
		
		return {}		
	end,

	--------------------------------------------------------------------------------------------------------------------
	getEvents = function(node)
		return { min = 0, max = 0 }
    end
}
)