registerNode("IOICutSequence",
{
	helptext = "Used to supply animation data from an outside source for cut sequence purposes",
	group = "Utilities",
	image = "IOICutSequence.png",
	id = generateNamespacedId(idNamespaces.G2, G2NodeTypeNumbers.NodeTypeIOICutSequence),
    --------------------------------------------------------------------------------------------------------------------
    
	functionPins = 
	{
		["Result"] = { 
						input = false, 
						array = false, 
						interfaces = {"Transforms", "Time", "Events"}, 
					},
	},
    
	attributes =
	{
		{ name = "SlotName", type = "string", value = "" },
	},
	    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
		local versionNumber = 3
		Stream:writeInt(versionNumber, "versionNumber")
		
		local slotName = getAttribute(node, "SlotName")
		Stream:writeInt(string.len(slotName), "SlotName_Length")
		Stream:writeString(slotName, "SlotName")
	end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
		return true
	end,
	
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
		-- This is expected to output a table containing all the rig indices that this nodes outputs transforms for
		-- Since we cannot know this information at export time, we simply return an empty set. We cannot guarantee
		-- at this point that any bones will be output.
		
		return {}		
	end,

}
)

