------------------------------------------------------------------------------------------------------------------------
-- IOI Delta Anim node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("IOIDeltaAnim",
  {
    helptext = "Subtracts Base transforms from Variation input",
    group = "Blends",
    image = "IOIDeltaAnim.png",
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOIDeltaAnim),

    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Variation"] = {
                       input = true, 
                       array = false,
                       interfaces = {"Transforms", "Time"},
                     },

      ["Base"] = { 
                       input = true, 
                       array = false, 
                       interfaces = {"Transforms", "Time"}, 
                     },

      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms", "Time"}, 
                   },
    },

    pinOrder = {"Variation", "Base", "Result"},

    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      { name = "Loop", type = "bool", value = true },
      { name = "UseSource1Additively", type = "bool", value = true},
      { name = "AdditiveBlendAttitude", type = "bool", value = false },
      { name = "AdditiveBlendPosition", type = "bool", value = false },
    },

    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local node0 = -1
      local node1 = -1
      local loop = getAttribute(node, "Loop")
      local useSource1Additively = getAttribute(node, "UseSource1Additively")
      local additiveAtt = getAttribute(node, "AdditiveBlendAttitude")
      local additivePos = getAttribute(node, "AdditiveBlendPosition")

      if isConnected{SourcePin  =(node .. ".Variation"), ResolveReferences = true} then 
        node0 = getConnectedNodeID(node, "Variation")
      end
      if isConnected{SourcePin  =(node .. ".Base"), ResolveReferences = true} then 
        node1 = getConnectedNodeID(node, "Base")
      end

      Stream:writeUInt(node0, "VariationConnectedNodeID")
      Stream:writeUInt(node1, "BaseConnectedNodeID")
      Stream:writeBool(loop, "Loop")
      Stream:writeBool(useSource1Additively, "UseSource1Additively")
      Stream:writeBool(additiveAtt, "AdditiveBlendAttitude")
      Stream:writeBool(additivePos, "AdditiveBlendPosition")
    end,

    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected{SourcePin  = (node..".Variation"), ResolveReferences = true} and isConnected{SourcePin  = (node..".Base"), ResolveReferences = true} then
        local nodesConnectedTo0 = listConnections{Object = (node..".Variation"), ResolveReferences = true}
        local nodesConnectedTo1 = listConnections{Object = (node..".Base"), ResolveReferences = true}
        local node0 = nodesConnectedTo0[1]
        local node1 = nodesConnectedTo1[1]
        if isValid(node0) ~= true or isValid(node1) ~= true then
          return nil, "IOI Delta Anim requires two valid input nodes"
        end

      else 
        return nil, ("IOI Delta Anim node " .. node .. " is missing a required connection to Variation and/or Base")
      end
      
      return true
    end,

    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local node0Channels = {} 
      local node1Channels = {} 
      if isConnected{SourcePin  = (node .. ".Variation"), ResolveReferences = true} then 
        local VariationTable = listConnections{Object = (node .. ".Variation"), ResolveReferences = true}
        local NodeConnectedTo0 = VariationTable[1]
        node0Channels = anim.getTransformChannels(NodeConnectedTo0)
      end

      if isConnected{SourcePin  = (node .. ".Base"), ResolveReferences = true} then 
        local BaseTable = listConnections{Object = (node .. ".Base"), ResolveReferences = true}
        local NodeConnectedTo1 = BaseTable[1]
        node1Channels = anim.getTransformChannels(NodeConnectedTo1)
      end

      local resultChannels = setUnion(node0Channels, node1Channels)
      return resultChannels
    end,

  }

)

------------------------------------------------------------------------------------------------------------------------
-- End of IOI DeltaAnim node definition.
------------------------------------------------------------------------------------------------------------------------
