-- vim: et ts=2
--------------------------------------------------------------------------------------------------------------------
registerNode("IOILookatNode",
	{
		helptext = "Testing of a IOI lookat node",
		group = "Utilities",
		image = "IOILookatNode.png",
		id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOILookAtNum),
		-- id = generateNamespacedId(idNamespaces.IOInteractive, 12 ),

		--------------------------------------------------------------------------------------------------------------------

		functionPins = 
		{
			 ["Source0"] = { input = true , array = false, interfaces = {"Transforms", "Time"} },
			 ["Result"]	= { input = false, array = false, interfaces = {"Transforms", "Time"} }
		},

		dataPins = 
		{
			 ["Direction"] = { input = true, array = false, type = "vector3" },
			 ["Weight"]		= { input = true, array = false, type = "float" },
		},

		pinOrder = { "Source0", "Direction" , "Weight" , "Result"	},

		--------------------------------------------------------------------------------------------------------------------

		attributes =
		{
			 { name = "NodeName"		 , type = "string", value = "IOILookAt" },
			 { name = "HeadBoneIndex", type = "int", value = 10 },
		},

		--------------------------------------------------------------------------------------------------------------------

		serialize = function(node, Stream)
			local nodeID = -1
			if isConnected{ SourcePin = (node .. ".Source0") , ResolveReferences = true} then 
				nodeID = getConnectedNodeID(node, "Source0")
			end
			Stream:writeUInt(nodeID, "Source0ConnectedToNodeID")
			
			nodeID = -1
			if isConnected{ SourcePin	= (node .. ".Direction"), ResolveReferences = true} then
				nodeID = getConnectedNodeID(node, "Direction")
			end
			Stream:writeUInt(nodeID, "IDConnectedToDirection")

			nodeID = -1
			if isConnected{ SourcePin	= (node .. ".Weight"), ResolveReferences = true} then
				nodeID = getConnectedNodeID(node, "Weight")
			end
			Stream:writeUInt(nodeID, "IDConnectedToWeight")
			
			-- Write Attribute Data
			Stream:writeUInt( getAttribute(node, "HeadBoneIndex") , "HeadBoneIndex")

		end,
		
		--------------------------------------------------------------------------------------------------------------------

		validate = function(node)
			-- Source connected test
			if isConnected{SourcePin	= (node..".Source0"), ResolveReferences = true} then
				local nodesConnectedTo0 = listConnections{Object = (node..".Source0"), ResolveReferences = true}
				local node0 = nodesConnectedTo0[1]
				if isValid(node0) ~= true then
					return nil, "IOILookAt requires a valid input node"
				end
			else 
				return nil, ("IOILookAt node " .. node .. " is missing a required connection to Source0")
			end
			
			-- Head bone index test
			local Index = getAttribute(node, "HeadBoneIndex")
			local Size = anim.getRigSize(nil)
			if ( Index<0	or Index>Size) then
				return nil, ("IOILookAt node " .. node .. " head bone index is out of rig bounds (" .. Index .. " vs " .. Size ..")" )
			end

			return true;
		end,
		
		--------------------------------------------------------------------------------------------------------------------

		getTransformChannels = function(node, set)
			if isConnected((node .. ".Source0")) then 
				local connectTable = listConnections{ Object = (node .. ".Source0") , ResolveReferences = true }
				local sourceNode = connectTable[1]
				return anim.getTransformChannels(sourceNode,set)
			else
				return {}
			end
		end,

		--------------------------------------------------------------------------------------------------------------------

		getEvents = function(node)
			if isConnected((node .. ".Source0")) then 
				local connectTable = listConnections{ Object = (node .. ".Source0") , ResolveReferences = true }
				local sourceNode = connectTable[1]
				local sourceEvents = anim.getEvents(sourceEvents)
				return sourceEvents
			else
				return { min = 0, max = 0 }
			end
		end

		--------------------------------------------------------------------------------------------------------------------

	}
)


