registerNode("IOIMirror",
  {
    helptext = "Mirrors the source transforms",
    group = "Utilities",
    image = "IOIMirror.png",
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOIMirror),
    --------------------------------------------------------------------------------------------------------------------

    attributes =
    {
		{ name = "SwapHandAttachers", type = "bool", value = false },
    },

	functionPins = 
	{
		["Source"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Result"] = {
							input = false, 
							array = false, 
							interfaces = {"Transforms", "Time"}, 
						},
    },
    dataPins = 
    {
       ["DisableMirror"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
    },
    
    pinOrder = { "Source", "Result", "DisableMirror" },
    
    --------------------------------------------------------------------------------------------------------------------
	serialize = function(node, Stream)
		
		-- The signature id is used to check wether this node has a version number or not.
		-- ie. if the first uint is SIGNATURE_ID then there is a version number following, else
		-- the first uint is the sourceNodeRuntimeID
		
		local SIGNATURE_ID = 1295788826		-- (0x4D3C2B1A) DO NOT EVER CHANGE THIS
		local version = 2					-- but change this instead if changing the serialization data
		local nodeID = -1
		local disableID = -1
		local bSwapAttachers = getAttribute(node, "SwapHandAttachers")
		
		if isConnected{SourcePin = (node .. ".Source") , ResolveReferences = true} then
			nodeID = getConnectedNodeID(node, "Source")
		end
		if isConnected{SourcePin = (node .. ".DisableMirror"), ResolveReferences = true} then
			disableID = getConnectedNodeID(node, "DisableMirror")
		end
		
		Stream:writeUInt(SIGNATURE_ID)
		Stream:writeUInt(version)
		Stream:writeUInt(nodeID, "IDConnectedTo" .. "Source" )
		Stream:writeUInt(disableID, "ID" .. "DisableMirror" )
		Stream:writeBool(bSwapAttachers, "SwapAttachers")
		
	end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
		-- todo: assert that if source is connected it must have the right id
		if isConnected{SourcePin  = (node..".Source"), ResolveReferences = true} then
			local nodesConnectedTo0 = listConnections{Object = (node..".Source"), ResolveReferences = true}
			local node0 = nodesConnectedTo0[1]
			if isValid(node0) ~= true then
				return nil, "IOISelect requires a valid input node"
			end
		else
			return nil, ("IOISelect node " .. node .. " is missing a required connection to Source")
		end
		return true
	end,
	
	--------------------------------------------------------------------------------------------------------------------
	getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected((node .. ".Source")) then 
        local SourceTable = listConnections{Object = (node .. ".Source"), ResolveReferences = true}
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
	end,
  }
)
