registerNode("IOIMirrorMatchEvents",
  {
    helptext = "Mirrors the source transforms and events",
    group = "Utilities",
    image = "IOIMirrorMatchEvents.png",
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOIMirrorMatchEvents),
    --------------------------------------------------------------------------------------------------------------------

    attributes =
    {
       { name = "RightFootEvent", type = "int", value = 100 },
       { name = "LeftFootEvent", type = "int", value = 101 },
       { name = "RightHandEvent", type = "int", value = 10 },
       { name = "LeftHandEvent", type = "int", value = 12 },
       { name = "SwapHandAttachers", type = "bool", value = false },
    },

	functionPins = 
	{
		["Source"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Result"] = {
							input = false, 
							array = false, 
							interfaces = {"Transforms", "Time", "Events"}, 
						},
    },
    
    pinOrder = { "Source", "Result" },
    
    --------------------------------------------------------------------------------------------------------------------
	serialize = function(node, Stream)
	
		local SIGNATURE_ID = 1295788826		-- (0x4D3C2B1A) DO NOT EVER CHANGE THIS
		Stream:writeUInt(SIGNATURE_ID)
		
		local version = 1
		Stream:writeUInt(version)
	
		local nodeID = -1
		if isConnected{SourcePin = (node .. ".Source") , ResolveReferences = true} then
			nodeID = getConnectedNodeID(node, "Source")
		end
		Stream:writeUInt(nodeID, "IDConnectedTo" .. "Source" )
		
	    local rightFootEvent = getAttribute(node, "RightFootEvent")
	    Stream:writeUInt(rightFootEvent)
		
	    local leftFootEvent = getAttribute(node, "LeftFootEvent")
	    Stream:writeUInt(leftFootEvent)

	    local rightHandEvent = getAttribute(node, "RightHandEvent")
	    Stream:writeUInt(rightHandEvent)
		
	    local leftHandEvent = getAttribute(node, "LeftHandEvent")
	    Stream:writeUInt(leftHandEvent)
	    
	    local bSwapAttachers = getAttribute(node, "SwapHandAttachers")
	    Stream:writeBool(bSwapAttachers, "SwapHandAttachers")
	end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
		-- todo: assert that if source is connected it must have the right id
		if isConnected{SourcePin  = (node..".Source"), ResolveReferences = true} then
			local nodesConnectedTo0 = listConnections{Object = (node..".Source"), ResolveReferences = true}
			local node0 = nodesConnectedTo0[1]
			if isValid(node0) ~= true then
				return nil, "IOISelect requires a valid input node"
			end
		else
			return nil, ("IOISelect node " .. node .. " is missing a required connection to Source")
		end
		return true
	end,
	
	--------------------------------------------------------------------------------------------------------------------
	getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected((node .. ".Source")) then 
        local SourceTable = listConnections{Object = (node .. ".Source"), ResolveReferences = true}
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
	end,
	
    getEvents = function(node)
		local _min = nil
		local _max = nil
        local connections = listConnections{Object = (node .. ".Source"), ResolveReferences = true}
        local connectedNode = connections[1]
        if connectedNode then
          local connectedEvents = anim.getEvents(connectedNode)

          if connectedEvents then
              _min = connectedEvents.min
              _max = connectedEvents.max
          end
        end

        return { min = _min or 0, max = _max or 0 }
    end,

  }
)
