------------------------------------------------------------------------------------------------------------------------
-- IOI ModifyBoneAlpha node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("IOIModifyBoneAlpha",
  { 
    helptext = "Modifies alpha on channels of an input buffer.",
    group = "Utilities",
    image = "IOIFilterTransforms.png",
    id = generateNamespacedId(idNamespaces.G2, G2NodeTypeNumbers.NodeTypeIOIModifyBoneAlpha),
    
    --interface = "Transforms",
    
	--------------------------------------------------------------------------------------------------------------------
	functionPins = 
	{
		["Filter"] = {
			input = true, 
			array = false,
			interfaces = {"Transforms"},
			},
                 
		["Result"] = { 
			input = false, 
			array = false, 
			interfaces = {"Transforms", "Time", "Events"}, 
			},
	},

	dataPins = 
	{
		["Weight"] = {
			input = true, 
			array = false, 
			type = "float", 
			},
	},

	pinOrder = {"Filter", "Result", "Weight"},

    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
    	{ name = "ChannelAlphaMultiplier", type = "floatArray", min = 0, max = 1, perAnimSet = true, syncWithRigChannels = true },
    },

   --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local sourceID = -1
      local nodesConnectedTo
      local sourceNode
      local weightID = -1

      if isConnected{SourcePin  = (node .. ".Filter"), ResolveReferences = true} then 
        sourceID = getConnectedNodeID(node, "Filter")
        nodesConnectedTo = listConnections{Object = (node .. ".Filter"), ResolveReferences = true}
        sourceNode = nodesConnectedTo[1]
      end

      if isConnected{SourcePin  = (node .. ".Weight"), ResolveReferences = true} then 
        weightID = getConnectedNodeID(node, "Weight")
      end
      
      local animSets = listAnimSets()
      local numAnimSets = table.getn(animSets)

      local versionNumber = 1
      Stream:writeUInt(versionNumber, "versionNumber")
      
      Stream:writeUInt(sourceID, "NodeConnectedTo")
      Stream:writeUInt(weightID, "WeightConnectedTo")
      Stream:writeUInt(numAnimSets, "NumAnimSets")

      for asIdx, asVal in animSets do
		
		local channelAlphaMultiplier = getAttribute(node, "ChannelAlphaMultiplier", asVal)

        Stream:writeUInt(table.getn(channelAlphaMultiplier), "ChannelCount")
        for i,v in ipairs(channelAlphaMultiplier) do
          Stream:writeFloat(v, "Alpha")
        end
      
      end

    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected{SourcePin  = (node..".Filter"), ResolveReferences = true} then
        local nodesConnectedTo = listConnections{Object = (node..".Filter"), ResolveReferences = true}
        local sourceNode = nodesConnectedTo[1]
        if isValid(sourceNode) ~= true then
          return nil, "Modify Bone Alpha requires a valid input node"
        end        
      else 
        return nil, ("Modify Bone Alpha node " .. node .. " is missing a required connection to Filter")
      end
      return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      if(isConnected{SourcePin  = (node .. ".Filter"), ResolveReferences = true}) then 
        local nodesConnectedTo = listConnections{Object = (node .. ".Filter"), ResolveReferences = true}
        local channels = anim.getTransformChannels(nodesConnectedTo[1])
        return channels
      end
      return {}
    end,

    --------------------------------------------------------------------------------------------------------------------
    getEvents = function(node)
      if isConnected{SourcePin  = (node..".Filter"), ResolveReferences = true} then
        local nodesConnectedTo = listConnections{Object = (node .. ".Fitler"), ResolveReferences = true}
        local sourceNode = nodesConnectedTo[1]
        local sourceEvents = anim.getEvents(sourceNode)
        return sourceEvents
      end
      return { min = 0, max = 0 }
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    onAttributeInherited = function(nodeName, attributeName, setName)
      if attributeName == "ChannelAlphaMultiplier" then
        -- init filter channels with default anim set rig size, set all outputs 'true' by default.
        local numChannels = anim.getRigSize(setName)
        local channelTable = { }
        for i = 1, numChannels do
          table.insert(channelTable, 1.0)
        end
        setAttribute(nodeName .. ".ChannelAlphaMultiplier", channelTable, setName)
      end
    end,
  }
)

------------------------------------------------------------------------------------------------------------------------
-- End of IOI ModifyBoneAlpha node definition.
------------------------------------------------------------------------------------------------------------------------



------------------------------------------------------------------------------------------------------------------------
-- IOI ModifyBoneAlpha custom editor
------------------------------------------------------------------------------------------------------------------------
registerAttributeDisplayInfo(
  "IOIModifyBoneAlpha",

  {
    { title = "Channel Alpha Multiplier",
      attributes = { "ChannelAlphaMultiplier" },
      type = "ChannelNameWidget",
    },
  }
)
------------------------------------------------------------------------------------------------------------------------
-- End of IOI ModifyBoneAlpha custom editor
------------------------------------------------------------------------------------------------------------------------




























