------------------------------------------------------------------------------------------------------------------------
-- IOIPartialMirrorAim node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("IOIPartialMirrorAim",
  {
    helptext = "Mirrors an aim animation up frome the Bip0, and re-targets the feet to the position where they were in the source animation",
    group = "Utilities",
    image = "IOIPartialMirrorAim.png",    
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOIPartialMirrorAim),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Source"] = {
                       input = true, 
                       array = false,
--                       interfaces = {"Transforms", "Time", "Events"},
						interfaces = {"Transforms"}, 
                     },
                     
      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms", "Time", "Events"}, 
                   },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    dataPins = 
    {
       ["MirrorWeight"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
    },
    
    pinOrder = {"Source", "Result", "MirrorWeight"},
    
    --------------------------------------------------------------------------------------------------------------------
    
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local inputNode = -1
      local MirrorWeightNode = -1
      
      if isConnected{SourcePin  = (node .. ".Source"), ResolveReferences = true} then 
        inputNode = getConnectedNodeID(node, "Source")
      end
      if isConnected{SourcePin  = (node .. ".MirrorWeight"), ResolveReferences = true} then 
        MirrorWeightNode = getConnectedNodeID(node, "MirrorWeight")
      end      
            
      
      Stream:writeUInt(inputNode, "InputNodeID")
      Stream:writeUInt(MirrorWeightNode, "MirrorWeightNodeID")      
      
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected(node..".Source") then
        local nodesConnected = listConnections{Object = (node..".Source"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOIPartialMirrorAim requires a valid input node"
        end
        
      else 
        return nil, ("IOIPartialMirrorAim node " .. node .. " is missing a required connection to Source")
      end
      
      if isConnected(node..".MirrorWeight") then
        local nodesConnected = listConnections{Object = (node..".MirrorWeight"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOIPartialMirrorAim requires a valid input node"
        end
        
      else 
        return nil, ("IOIPartialMirrorAim node " .. node .. " is missing a required connection to MirrorWeight")
      end
      
       
      
      return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected((node .. ".Source")) then 
        local SourceTable = listConnections{Object = (node .. ".Source"), ResolveReferences = true}
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
    end,

  }

)

------------------------------------------------------------------------------------------------------------------------
-- End of IOIPartialMirrorAim node definition.
------------------------------------------------------------------------------------------------------------------------






