------------------------------------------------------------------------------------------------------------------------
-- SingleFrame node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("IOIPelvisOffset",
  {
    helptext = "Applies an offset vector to the pelvis",
    group = "Utilities",
    image = "IOIPelvisOffset.png",    
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOIPelvisOffset),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Source"] = {
                       input = true, 
                       array = false,
--                       interfaces = {"Transforms", "Time", "Events"},
						interfaces = {"Transforms"}, 
                     },
                     
      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms", "Time", "Events"}, 
                   },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    dataPins = 
    {
       ["OffsetWeight"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
       ["OffsetVector"] = {
                      input = true, 
                      array = false, 
                      type = "vector3", 
                    },
    },
    
    pinOrder = {"Source", "Result", "OffsetWeight", "OffsetVector"},
    
    --------------------------------------------------------------------------------------------------------------------

    attributes =
    {
      { name = "OffsetToBone", type = "string", value = "", perAnimSet = false },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local inputNode = -1
      local OffsetWeightNode = -1
      local OffsetVectorNode = -1
      
      if isConnected{SourcePin  = (node .. ".Source"), ResolveReferences = true} then 
        inputNode = getConnectedNodeID(node, "Source")
      end
      if isConnected{SourcePin  = (node .. ".OffsetWeight"), ResolveReferences = true} then 
        OffsetWeightNode = getConnectedNodeID(node, "OffsetWeight")
      end
      if isConnected{SourcePin  = (node .. ".OffsetVector"), ResolveReferences = true} then 
        OffsetVectorNode = getConnectedNodeID(node, "OffsetVector")
      end

	  Stream:writeUInt(inputNode, "InputNodeID")
      Stream:writeUInt(OffsetWeightNode, "OffsetWeightNodeID")
      Stream:writeUInt(OffsetVectorNode, "OffsetVectorNodeID")
      
      local boneName = getAttribute(node, "OffsetToBone")            
      Stream:writeInt(string.len(boneName), "OffsetToBone_Length") 
      Stream:writeString(boneName, "OffsetToBone")
            
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected(node..".Source") then
        local nodesConnected = listConnections{Object = (node..".Source"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "SingleFrame requires a valid input node"
        end
        
      else 
        return nil, ("IOIPelvisOffset node " .. node .. " is missing a required connection to Source")
      end
      
      if isConnected(node..".OffsetWeight") then
        local nodesConnected = listConnections{Object = (node..".OffsetWeight"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "SingleFrame requires a valid input node"
        end
        
      else 
        return nil, ("IOIPelvisOffset node " .. node .. " is missing a required connection to OffsetWeight")
      end
      
      
      if isConnected(node..".OffsetVector") then
        local nodesConnected = listConnections{Object = (node..".OffsetVector"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "SingleFrame requires a valid input node"
        end
        
      else 
        return nil, ("IOIPelvisOffset node " .. node .. " is missing a required connection to OffsetVector")
      end
      
      return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected((node .. ".Source")) then 
        local SourceTable = listConnections{Object = (node .. ".Source"), ResolveReferences = true}
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
    end,

  }

)

------------------------------------------------------------------------------------------------------------------------
-- End of IOIPelvisOffset node definition.
------------------------------------------------------------------------------------------------------------------------






