------------------------------------------------------------------------------------------------------------------------
-- Scale anim node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("IOIScaleAnim",
{
    helptext = "Scales bones, translation of trajectory and orientation of trajectory.",
    group = "Utilities",
    image = "IOIGroundRotation.png", 
    id = generateNamespacedId(idNamespaces.G2, G2NodeTypeNumbers.NodeTypeIOIScaleAnim),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
		["Reference"] = { input = true,	array = false, interfaces = {"Transforms", "Time", "Events"}, },
		["Source"] = { input = true,	array = false, interfaces = {"Transforms", "Time", "Events"}, },
		["Result"] = { input = false,	array = false, interfaces = {"Transforms", "Time", "Events"}, },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    dataPins = 
    {
		["BoneScale"] = { input = true,	array = false, type = "float" },
		["TrajectoryTranslationScale"] = { input = true, array = false, type = "float" },
		["TrajectoryOrientationScale"] = { input = true, array = false, type = "float" },
		["TimeScale"] = { input = true, array = false, type = "float" },
	},
    
    pinOrder = {"Reference", "Source", "BoneScale", "TrajectoryTranslationScale", "TrajectoryOrientationScale", "TimeScale", "Result" },
    
    --------------------------------------------------------------------------------------------------------------------
    
    attributes =
    {
    },
    
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
	  local referenceNode = -1
      local inputNode = -1
      local scaleBoneNode = -1
      local scaleTrajectoryTranslationNode = -1
      local scaleTrajectoryOrientationNode = -1
	  local scaleTimeNode = -1
      
      if isConnected{SourcePin  = (node .. ".Reference"), ResolveReferences = true} then 
        referenceNode = getConnectedNodeID(node, "Reference")
      end

      if isConnected{SourcePin  = (node .. ".Source"), ResolveReferences = true} then 
        inputNode = getConnectedNodeID(node, "Source")
      end
      
      if isConnected{SourcePin  = (node .. ".BoneScale"), ResolveReferences = true} then 
        scaleBoneNode = getConnectedNodeID(node, "BoneScale")
      end
      
      if isConnected{SourcePin = (node .. ".TrajectoryTranslationScale"), ResolveReferences = true} then
		scaleTrajectoryTranslationNode = getConnectedNodeID(node, "TrajectoryTranslationScale")
      end
      
      if isConnected{SourcePin  = (node .. ".TrajectoryOrientationScale"), ResolveReferences = true} then 
        scaleTrajectoryOrientationNode = getConnectedNodeID(node, "TrajectoryOrientationScale")
      end

      if isConnected{SourcePin  = (node .. ".TimeScale"), ResolveReferences = true} then 
        scaleTimeNode = getConnectedNodeID(node, "TimeScale")
      end

      Stream:writeUInt(2, "Version")
	  Stream:writeUInt(referenceNode, "ReferenceNodeID")
      Stream:writeUInt(inputNode, "InputNodeID")
      Stream:writeUInt(scaleBoneNode, "BoneScaleID")
      Stream:writeUInt(scaleTrajectoryTranslationNode, "TrajectoryTranslationScaleID")
      Stream:writeUInt(scaleTrajectoryOrientationNode, "TrajectoryOrientationScaleID")
      Stream:writeUInt(scaleTimeNode, "TimeScaleID")
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected(node..".Source") then
        local nodesConnected = listConnections{Object = (node..".Source"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOIScaleAnim requires a valid input node"
        end
      else 
        return nil, ("IOIScaleAnim node " .. node .. " is missing a required connection to Source")
      end

	  return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
	  local node0Channels = {} 
      local node1Channels = {} 
      if isConnected{SourcePin  = (node .. ".Reference"), ResolveReferences = true} then 
        local Source0Table = listConnections{Object = (node .. ".Source0") , ResolveReferences = true}
        local NodeConnectedTo0 = Source0Table[1]
        node0Channels = anim.getTransformChannels(NodeConnectedTo0)
      end

      if isConnected{SourcePin  = (node .. ".Source"), ResolveReferences = true} then 
        local Source1Table = listConnections{Object = (node .. ".Source1") , ResolveReferences = true}
        local NodeConnectedTo1 = Source1Table[1]
        node1Channels = anim.getTransformChannels(NodeConnectedTo1)
      end

      local resultChannels = setUnion(node0Channels, node1Channels)
      return resultChannels
    end,

  }
)

------------------------------------------------------------------------------------------------------------------------
-- End of IOIScaleAnim node definition.
------------------------------------------------------------------------------------------------------------------------






