registerNode("IOISelectNode",
  {
    helptext = "Select Node",
    group = "Utilities",
    image = "IOISelectNode.png",
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOISelectNum),
    --------------------------------------------------------------------------------------------------------------------

    attributes =
    {
       { name = "NodeName", type = "string", value = "IOISelectNode" },
       { name = "RandomSelectAtInit", type = "bool", value = false },
       { name = "UpdateSelectIndex", type = "bool", value = true },
    },

    dataPins = 
    {
       ["SelectIndex"] = {
							input = true, 
							array = false, 
							type = "float", 
						},
       ["BlendTime"] = {
							input = true, 
							array = false, 
							type = "float", 
						},
    },
    
	functionPins = 
	{
		["Source0"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source1"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source2"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source3"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source4"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source5"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source6"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source7"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source8"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source9"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source10"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source11"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source12"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source13"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source14"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source15"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source16"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source17"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source18"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source19"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source20"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source21"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source22"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Source23"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time"},
						},
		["Result"] = {
							input = false, 
							array = false, 
							interfaces = {"Transforms", "Time"}, 
						},
    },
    
    pinOrder = { "Source0", "Source1", "Source2", "Source3", "Source4", "Source5", "Source6", "Source7", "Source8", "Source9", "Source10", "Source11", "Source12", "Source13", "Source14", "Source15", "Source16", "Source17", "Source18", "Source19", "Source20", "Source21", "Source22", "Source23", "SelectIndex" , "BlendTime" , "Result" },
    
    --------------------------------------------------------------------------------------------------------------------
	serialize = function(node, Stream)
	
		for nodeIndex=0,23 do
			local nodeID = -1
			nodeName = "Source" .. tostring(nodeIndex)
			if(isConnected{SourcePin = (node .. "." .. nodeName) , ResolveReferences = true}) then
				nodeID = getConnectedNodeID(node, nodeName)
			end
			Stream:writeUInt(nodeID, "IDConnectedTo" .. nodeName )
		end
		
		local nodeID = -1
		if(isConnected{ SourcePin  = (node .. ".SelectIndex"), ResolveReferences = true}) then
			nodeID = getConnectedNodeID(node, "SelectIndex")
		end
		Stream:writeUInt(nodeID, "IDConnectedToSelectIndex")
		
		nodeID = -1
		if isConnected{ SourcePin  = (node .. ".BlendTime"), ResolveReferences = true} then
			nodeID = getConnectedNodeID(node, "BlendTime")
		end
		Stream:writeUInt(nodeID, "IDConnectedToBlendTime")
		
	    local randomSelectAtInit = getAttribute(node, "RandomSelectAtInit")
	    Stream:writeBool(randomSelectAtInit)
	    
	    local updateSelectIndex = getAttribute(node, "UpdateSelectIndex")
	    Stream:writeBool(updateSelectIndex)
		
	end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
		-- todo: assert that if any source is connected it must have the right id
		if(isConnected{SourcePin  = (node..".Source0"), ResolveReferences = true}) then
			local nodesConnectedTo0 = listConnections{Object = (node..".Source0"), ResolveReferences = true}
			local node0 = nodesConnectedTo0[1]
			if isValid(node0) ~= true then
				return nil, "IOISelect requires a valid input node"
			end
		else
			return nil, ("IOISelect node " .. node .. " is missing a required connection to Source0")
		end
		return true;
	end,
	
	--------------------------------------------------------------------------------------------------------------------
	getTransformChannels = function(node)
		local resultChannels = {} 
		for i=0,23 do
			if(isConnected{SourcePin  = (node .. ".Source" .. tostring(i) ), ResolveReferences = true}) then 
				local SourceTable = listConnections{Object = (node .. ".Source" .. tostring(i)) , ResolveReferences = true}
				local NodeConnectedTo = SourceTable[1]
				resultChannels = setUnion( anim.getTransformChannels(NodeConnectedTo) , resultChannels)
			end
		end
		return resultChannels
	end,
	
	getEvents = function(node)
		return { min = 0, max = 0 }
	end
}
)


