------------------------------------------------------------------------------------------------------------------------
-- IOISneakModifier node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("IOISneakModifier",
  {
    helptext = "Applies an offset vector to the pelvis and retarget feets back",
    group = "Utilities",
    image = "IOISneakModifier.png",   
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOISneakModifier),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Source"] = { input = true,	array = false, interfaces = {"Transforms", "Time"}, },
      ["Result"] = { input = false, array = false, interfaces = {"Transforms", "Time"}, },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    dataPins = 
    {
       ["Weight"]		= { input = true, array = false, type = "float", },
       ["PelvisOffset"] = { input = true, array = false, type = "vector3", },
       ["PelvisAngle"]	= { input = true, array = false, type = "float", },
       ["PlaySpeed"]	= { input = true, array = false, type = "float", },  
	   ["LeftHandQuat"] = { input = true, array = false, type = "vector4", },     
    },
    
    pinOrder = {"Source", "Result", "Weight", "PelvisOffset", "PelvisAngle", "PlaySpeed", "LeftHandQuat"},
    
    --------------------------------------------------------------------------------------------------------------------
    
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local inputNode = -1
      local WeightNode = -1
      local PelvisOffsetNode = -1
      local PelvisAngleNode = -1
      local PlaySpeedNode = -1
      local LeftHandQuatNode = -1
      
      if isConnected{SourcePin  = (node .. ".Source"), ResolveReferences = true} then 
        inputNode = getConnectedNodeID(node, "Source")
      end
      if isConnected{SourcePin  = (node .. ".Weight"), ResolveReferences = true} then 
        WeightNode = getConnectedNodeID(node, "Weight")
      end
      if isConnected{SourcePin  = (node .. ".PelvisOffset"), ResolveReferences = true} then 
        PelvisOffsetNode = getConnectedNodeID(node, "PelvisOffset")
      end
      if isConnected{SourcePin  = (node .. ".PelvisAngle"), ResolveReferences = true} then 
        PelvisAngleNode = getConnectedNodeID(node, "PelvisAngle")
      end
      if isConnected{SourcePin  = (node .. ".PlaySpeed"), ResolveReferences = true} then 
        PlaySpeedNode = getConnectedNodeID(node, "PlaySpeed")
      end

      if isConnected{SourcePin  = (node .. ".LeftHandQuat"), ResolveReferences = true} then 
        LeftHandQuatNode = getConnectedNodeID(node, "LeftHandQuat")
      end
           
      
      Stream:writeUInt(inputNode, "InputNodeID")
      Stream:writeUInt(WeightNode, "WeightNodeID")
      Stream:writeUInt(PelvisOffsetNode, "PelvisOffsetNodeID")
      Stream:writeUInt(PelvisAngleNode, "PelvisAngleNodeID")
      Stream:writeUInt(PlaySpeedNode, "PlaySpeedNodeID")            
      Stream:writeUInt(LeftHandQuatNode, "LeftHandQuatNodeID")
      
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected(node..".Source") then
        local nodesConnected = listConnections{Object = (node..".Source"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOISneakModifier requires a valid input node"
        end
        
      else 
        return nil, ("IOISneakModifier node " .. node .. " is missing a required connection to Source")
      end
      
      if isConnected(node..".Weight") then
        local nodesConnected = listConnections{Object = (node..".Weight"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOISneakModifier requires a valid input node"
        end
        
      else 
        return nil, ("IOISneakModifier node " .. node .. " is missing a required connection to Weight")
      end
      
      
      if isConnected(node..".PelvisOffset") then
        local nodesConnected = listConnections{Object = (node..".PelvisOffset"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOISneakModifier requires a valid input node"
        end
        
      else 
        return nil, ("IOISneakModifier node " .. node .. " is missing a required connection to PelvisOffset")
      end


      if isConnected(node..".PelvisAngle") then
        local nodesConnected = listConnections{Object = (node..".PelvisAngle"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOISneakModifier requires a valid input node"
        end
        
      else 
        return nil, ("IOISneakModifier node " .. node .. " is missing a required connection to PelvisAngle")
      end

	  if isConnected(node..".PlaySpeed") then
        local nodesConnected = listConnections{Object = (node..".PlaySpeed"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOISneakModifier requires a valid input node"
        end
        
      else 
        return nil, ("IOISneakModifier node " .. node .. " is missing a required connection to PlaySpeed")
      end

	  if isConnected(node..".LeftHandQuat") then
        local nodesConnected = listConnections{Object = (node..".LeftHandQuat"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOISneakModifier requires a valid input node"
        end
        
      else 
        return nil, ("IOISneakModifier node " .. node .. " is missing a required connection to LeftHandQuat")
      end

      return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected((node .. ".Source")) then 
        local SourceTable = listConnections{Object = (node .. ".Source"), ResolveReferences = true}
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
    end,

  }

)

------------------------------------------------------------------------------------------------------------------------
-- End of IOISneakModifier node definition.
------------------------------------------------------------------------------------------------------------------------






