------------------------------------------------------------------------------------------------------------------------
-- Translation scale node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("IOITranslationScale",
  {
    helptext = "Applies an a scale to the translation of the ground",
    group = "Utilities",
    image = "IOITranslationScale.png", 
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOITranslationScale),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
		["Source"] = { input = true,	array = false, interfaces = {"Transforms", "Time", "Events"}, },
		["Result"] = { input = false,	array = false, interfaces = {"Transforms", "Time", "Events"}, },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    dataPins = 
    {
		["Scale"] = { input = true,	array = false, type = "float" },
	},
    
    pinOrder = {"Source", "Scale", "Result" },
    
    --------------------------------------------------------------------------------------------------------------------
    
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local inputNode = -1
      local scaleNode = -1
      
      if isConnected{SourcePin  = (node .. ".Source"), ResolveReferences = true} then 
        inputNode = getConnectedNodeID(node, "Source")
      end
      if isConnected{SourcePin  = (node .. ".Scale"), ResolveReferences = true} then 
        scaleNode = getConnectedNodeID(node, "Scale")
      end
      
      Stream:writeUInt(inputNode, "InputNodeID")
      Stream:writeUInt(scaleNode, "ScaleNodeID")
      
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected(node..".Source") then
        local nodesConnected = listConnections{Object = (node..".Source"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOITranslationScale requires a valid input node"
        end
        
      else 
        return nil, ("IOITranslationScale node " .. node .. " is missing a required connection to Source")
      end
      
      if isConnected(node..".Scale") then
        local nodesConnected = listConnections{Object = (node..".Scale"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "IOITranslationScale requires a valid input node"
        end
        
      else 
        return nil, ("IOITranslationScale node " .. node .. " is missing a required connection to Scale")
      end
      
	  return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected((node .. ".Source")) then 
        local SourceTable = listConnections{Object = (node .. ".Source"), ResolveReferences = true}
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
    end,

  }
)

------------------------------------------------------------------------------------------------------------------------
-- End of IOITranslationScale node definition.
------------------------------------------------------------------------------------------------------------------------