registerNode("IOIVariation",
{
	helptext = "The variation node can play different animation sources, based on a selected character type",
	group = "Utilities",
	image = "IOIVariation.png",
	id = generateNamespacedId(idNamespaces.G2, G2NodeTypeNumbers.NodeTypeIOIVariation),
	--------------------------------------------------------------------------------------------------------------------
    
	functionPins = 
	{
		["Result"] = { 
						input = false,
						array = false,
						interfaces = {"Transforms", "Time", "Events"},
					},
	},
	
	attributes =
	{
		{ name = "VariationName", type = "string", value = "" },
		{ name = "Loop", type = "bool", value = true },
		{ name = "PlayBackwards", type = "bool", value = false },
		{ name = "GenerateAnimationDeltas", type = "bool", value = false },
		{ name = "StartEventIndex", type = "int", value = 0},
		{ name = "ClipStartFraction", type = "float", min = 0.0, max = 1.0, value = 0.0, perAnimSet = false },
		{ name = "ClipEndFraction", type = "float", min = 0.0, max = 1.0, value = 1.0, perAnimSet = false },
		{ name = "BlendFromLastFrame", type = "bool", value = false },
	},
	
	--------------------------------------------------------------------------------------------------------------------
	serialize = function(node, Stream)
		-- Write a node version number as the first bit of data. This can then be used to make
		-- the node definition creator backwards compatible with earlier node versions. Thus we should be able
		-- submit new versions of our animation node without breaking the Gfx build if we keep the node definition
		-- creator backwards compatible.
		
		-- Custom data specific to the IOI variation node:
		Stream:writeInt(6, "VariationNodeVersion");

		local loopAnimation = getAttribute(node, "Loop")
		local generateAnimationDeltas = getAttribute(node, "GenerateAnimationDeltas")
		local clipStartFraction = getAttribute(node, "ClipStartFraction", asVal)
		local clipEndFraction = getAttribute(node, "ClipEndFraction", asVal)
		local variationName = getAttribute(node, "VariationName")
		local startEventIndex = getAttribute(node, "StartEventIndex")
		local blendFromLastFrame = getAttribute(node, "BlendFromLastFrame")
		local playBackwards = getAttribute(node, "PlayBackwards")
		
		-- Make sure the clip end time is greater or equal to the clip start time.
		if(clipEndFraction < clipStartFraction) then
			clipEndFraction = clipStartFraction
		end
		
		Stream:writeBool(loopAnimation, "Loop")
		Stream:writeBool(generateAnimationDeltas, "GenerateAnimationDeltas")
		Stream:writeFloat(clipStartFraction, "ClipStartFraction")
		Stream:writeFloat(clipEndFraction, "ClipEndFraction")
		Stream:writeInt(startEventIndex, "StartEventIndex")
		Stream:writeBool(blendFromLastFrame, "BlendFromLastFrame")
		Stream:writeBool(playBackwards, "PlayBackwards")
		
		-- Must be last!
		Stream:writeInt(string.len(variationName), "VariationName_Length")
		Stream:writeString(variationName, "VariationName")
	end,
    
	--------------------------------------------------------------------------------------------------------------------
	validate = function(node)
		local valid = true
		local errorMessage = ""

		if(getAttribute(node, "VariationName") == nil) then
			errorMessage = errorMessage.."Error: VariationName is nil!\n"
			valid = false;
		end
		
		if(getAttribute(node, "VariationName") == "") then
			errorMessage = errorMessage.."Error: VariationName is the empty string!\n"
			valid = false;
		end
		if(getAttribute(node, "StartEventIndex") < 0) then
			errorMessage = errorMessage.."Error: Start event index is negative!\n"
			valid = false;
		end

		if(valid) then
			return true
		else
			return nil, errorMessage 
		end
	end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
		-- This is expected to output a table containing all the rig indices that this nodes outputs transforms for
		-- Since we cannot know this information at export time, we simply return an empty set. We cannot guarantee
		-- at this point that any bones will be output.
		
		return {}
	end,

	--------------------------------------------------------------------------------------------------------------------
	getEvents = function(node)
		return { min = 0, max = 0 }
    end
}
)