------------------------------------------------------------------------------------------------------------------------
-- OperatorFloat node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("OperatorFloatIOI",
  {
    helptext = "Simple operation on single Float parameter",
    group = "Operators",
    image = "OperatorFloat.png",
    id = generateNamespacedId(idNamespaces.NaturalMotion, 110),

    --------------------------------------------------------------------------------------------------------------------
    dataPins =
    {
      ["Input"] = {
                    input = true,
                    array = false,
                    type = "float",
                  },

      ["Result"] = {
                     input = false,
                     array = false,
                     type = "float",
                    },
    },

    pinOrder = {"Input", "Result"},

    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      { name = "Operation",
        type = "string",
        value = "sin"
      },
    },

    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local inputID = getConnectedNodeID( (node .. ".Input"))
      local operation = getAttribute(node, "Operation")
      local operationCode = -1
      -- Expand this list as necessary.  Must be consistent with enum in mrNodeOperatorFloat.h
      if operation == "sin" then operationCode = 0 end
      if operation == "cos" then operationCode = 1 end
      if operation == "tan" then operationCode = 2 end
      if operation == "exp" then operationCode = 3 end
      if operation == "log" then operationCode = 4 end
      if operation == "sqrt" then operationCode = 5 end
      if operation == "abs" then operationCode = 6 end
      if operation == "rnd" then operationCode = 7 end
      if operation == "round" then operationCode = 8 end

      Stream:writeInt(inputID, "NodeConnected")
      Stream:writeInt(operationCode, "OperationCode")
    end,

    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      local nodesConnected = listConnections{Object =(node..".Input"), ResolveReferences = true}
      local inputNode = nodesConnected[1]
      local operation = getAttribute(node, "Operation")
      if (inputNode == nil) then
        return nil, "Missing connection to Operator Float"
      end
      if not isValid(inputNode) then
        return nil, "Operator Float requires a valid input"
      end
      if (operation ~= "sin") and
         (operation ~= "cos") and
         (operation ~= "tan") and
         (operation ~= "exp") and
         (operation ~= "log") and
         (operation ~= "sqrt") and
         (operation ~= "abs") and
         (operation ~= "rnd") and
         (operation ~= "round") then
        return nil, "Unrecognised operation \'" .. operation .. "\'.  Must be one of sin, cos, tan, exp, log, sqrt, abs, rnd, round."
      end
      return true
    end,
  }
)

------------------------------------------------------------------------------------------------------------------------
-- End of OperatorFloat node definition.
------------------------------------------------------------------------------------------------------------------------
