registerNode("PlaySpeedModifier",
  {
    helptext = "Sample PlaySpeedModifier node which allows to modify the time update.",
    image = "PlaySpeedModifier.png",
    id = generateNamespacedId(idNamespaces.NaturalMotion, 125), -- We keep using this type number so that we don't need to update existing networks when we upgrade for real
    
    functionPins = 
    {
      ["Source"] = {
                       input = true, 
                       array = false,
                       interfaces = {"Transforms","Time"},
                     },
                     
      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms","Time"}, 
                   },
    },
    
    dataPins = 
    {
	     ["PlaySpeedFactor"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
    },
    
    pinOrder = {"Source", "Result","PlaySpeedFactor"},
    
    attributes =
    {
    },
    
    serialize = function(node, Stream)
      local inputNode = -1
      local speedFactor = 1
      
      if isConnected((node .. ".Source") ) then 
        inputNode = getConnectedNodeID(node, "Source")
      end
      Stream:writeUInt(inputNode, "InputNodeID")
      
       if isConnected( (node .. ".PlaySpeedFactor") ) then 
        speedFactor = getConnectedNodeID(node, "PlaySpeedFactor")
      end
      Stream:writeUInt(speedFactor, "IDSpeedFactor")
    end,
    
    validate = function(node)
      if not isConnected(node..".Source") then
        return nil, ("PlaySpeedModifier node " .. node .. " is missing a required connection to Source")
      end
      if not isConnected( (node .. ".PlaySpeedFactor") ) then 
        return nil, ("PlaySpeedModifier node " .. node .. " is missing a required connection to PlaySpeedFactor") 
      end 
      return true
    end,
    
    getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected((node .. ".Source")) then 
        local SourceTable = listConnections( (node .. ".Source") )
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
    end,

  }

)







