registerNode("SelectNodeMatchEvents",
  {
    helptext = "Select Node Match Events",
    group = "Utilities",
    image = "SelectNodeMatchEvents.png",
    id = generateNamespacedId(idNamespaces.G2, G2NodeTypeNumbers.NodeTypeIOISelectNodeMatchEvents),
    --------------------------------------------------------------------------------------------------------------------

    attributes =
    {
       { name = "SelectIndex0", type = "float", value = 0.0 },
       { name = "SelectIndex1", type = "float", value = 1.0 },
       { name = "SelectIndex2", type = "float", value = 2.0 },
       { name = "SelectIndex3", type = "float", value = 3.0 },
       { name = "SelectIndex4", type = "float", value = 4.0 },
       { name = "SelectIndex5", type = "float", value = 5.0 },
       { name = "SelectIndex6", type = "float", value = 6.0 },
       { name = "SelectIndex7", type = "float", value = 7.0 },
       { name = "SelectIndex8", type = "float", value = 8.0 },
       { name = "SelectIndex9", type = "float", value = 9.0 },
       { name = "SelectIndex10", type = "float", value = 10.0 },
       { name = "SelectIndex11", type = "float", value = 11.0 },
       { name = "SelectIndex12", type = "float", value = 12.0 },
       { name = "SelectIndex13", type = "float", value = 13.0 },
       { name = "SelectIndex14", type = "float", value = 14.0 },
       { name = "SelectIndex15", type = "float", value = 15.0 },
       { name = "SelectIndex16", type = "float", value = 16.0 },
       { name = "SelectIndex17", type = "float", value = 17.0 },
       { name = "SelectIndex18", type = "float", value = 18.0 },
       { name = "SelectIndex19", type = "float", value = 19.0 },
       { name = "SelectIndex20", type = "float", value = 20.0 },
       { name = "SelectIndex21", type = "float", value = 21.0 },
       { name = "SelectIndex22", type = "float", value = 22.0 },
       { name = "SelectIndex23", type = "float", value = 23.0 },
       { name = "RandomSelectAtInit", type = "bool", value = false },
       { name = "UpdateSelectIndex", type = "bool", value = true },
       { name = "IgnoreSourceTrajectory", type = "bool", value = false },
       { name = "EnableRealign", type = "bool", value = false },
	   { name = "DestEventSequenceOffset", type = "int", value = 0, min = 0},
       { name = "DestStartEventIndex", type = "int", value = 0, min = 0},
       { name = "UsingDestStartEventIndex", type = "bool", value = false},
    },

    dataPins = 
    {
       ["SelectIndex"] = {
							input = true, 
							array = false, 
							type = "float", 
						},
       ["BlendTime"] = {
							input = true, 
							array = false, 
							type = "float", 
						},
    },
    
	functionPins = 
	{
		["Source0"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source1"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source2"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source3"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source4"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source5"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source6"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source7"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source8"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source9"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source10"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source11"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source12"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source13"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source14"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source15"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source16"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source17"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source18"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source19"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source20"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source21"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source22"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source23"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Result"] = {
							input = false, 
							array = false, 
							interfaces = {"Transforms", "Time", "Events"}, 
						},
    },
    
    pinOrder = {
		"Source0",
		"Source1",
		"Source2",
		"Source3",
		"Source4",
		"Source5",
		"Source6",
		"Source7",
		"Source8",
		"Source9",
		"Source10",
		"Source11",
		"Source12",
		"Source13",
		"Source14",
		"Source15",
		"Source16",
		"Source17",
		"Source18",
		"Source19",
		"Source20",
		"Source21",
		"Source22",
		"Source23",
		"SelectIndex",
		"BlendTime",
		"Result" },
    
    --------------------------------------------------------------------------------------------------------------------
	serialize = function(node, Stream)
		Stream:writeUInt(2, "Version")
	
		for nodeIndex=0,23 do
			local nodeID = -1
			nodeName = "Source" .. tostring(nodeIndex)
			if(isConnected{SourcePin = (node .. "." .. nodeName) , ResolveReferences = true}) then
				nodeID = getConnectedNodeID(node, nodeName)
			end
			Stream:writeUInt(nodeID, nodeName)
			
			local attributeName = "SelectIndex" .. tostring(nodeIndex)
			Stream:writeFloat(getAttribute(node, attributeName), attributeName)
		end
		
		local nodeID = -1
		if(isConnected{ SourcePin  = (node .. ".SelectIndex"), ResolveReferences = true}) then
			nodeID = getConnectedNodeID(node, "SelectIndex")
		end
		Stream:writeUInt(nodeID, "IDConnectedToSelectIndex")
		
		nodeID = -1
		if isConnected{ SourcePin  = (node .. ".BlendTime"), ResolveReferences = true} then
			nodeID = getConnectedNodeID(node, "BlendTime")
		end
		Stream:writeUInt(nodeID, "IDConnectedToBlendTime")
		
	    local randomSelectAtInit = getAttribute(node, "RandomSelectAtInit")
	    Stream:writeBool(randomSelectAtInit, "RandomSelectAtInit")
	    local updateSelectIndex = getAttribute(node, "UpdateSelectIndex")
	    Stream:writeBool(updateSelectIndex, "UpdateSelectIndex")
	    
	    Stream:writeBool(getAttribute(node, "IgnoreSourceTrajectory"), "IgnoreSourceTrajectory")
	    Stream:writeBool(getAttribute(node, "EnableRealign"), "EnableRealign")
	    Stream:writeUInt(getAttribute(node, "DestStartEventIndex"), "DestStartEventIndex")
	    Stream:writeUInt(getAttribute(node, "DestEventSequenceOffset"), "DestEventSequenceOffset")
	    Stream:writeBool(getAttribute(node, "UsingDestStartEventIndex"), "UsingDestStartEventIndex")
	end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
		--[[
		-- assert that source indices are strictly increasing
   		for nodeIndex=0,23 do
			local first = true
			local previousSourceIndex = 0
			local nodeName = "Source" .. tostring(nodeIndex)
			if(isConnected{SourcePin = (node .. "." .. nodeName) , ResolveReferences = true}) then
				local sourceIndexName = "SourceIndex" .. tostring(nodeIndex)
				local currentSourceIndex = getAttribute(node, sourceIndexName)
				if(first ~= true) then
					if(currentSourceIndex >= previousSourceIndex) then
						return nil, ("SelectNodeMatchEvents " .. node .. " only allows increasing source index numbers")
					end
				end
				first = false
				previousSourceIndex = currentSourceIndex
			end
		end
		]]--

    
		-- todo: assert that if any source is connected it must have the right id
		if(isConnected{SourcePin  = (node..".Source0"), ResolveReferences = true}) then
			local nodesConnectedTo0 = listConnections{Object = (node..".Source0"), ResolveReferences = true}
			local node0 = nodesConnectedTo0[1]
			if isValid(node0) ~= true then
				return nil, "SelectNodeMatchEvents requires a valid input node"
			end
		else
			return nil, ("SelectNodeMatchEvents " .. node .. " is missing a required connection to Source0")
		end
		return true;
	end,
	
	--------------------------------------------------------------------------------------------------------------------
	getTransformChannels = function(node)
		local resultChannels = {} 
		for i=0,23 do
			if(isConnected{SourcePin  = (node .. ".Source" .. tostring(i) ), ResolveReferences = true}) then 
				local SourceTable = listConnections{Object = (node .. ".Source" .. tostring(i)) , ResolveReferences = true}
				local NodeConnectedTo = SourceTable[1]
				resultChannels = setUnion( anim.getTransformChannels(NodeConnectedTo) , resultChannels)
			end
		end
		return resultChannels
	end,
	
	getEvents = function(node)
		return { min = 0, max = 0 }
	end
}
)
