------------------------------------------------------------------------------------------------------------------------
-- SingleFrame node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("SingleFrame",
  {
    helptext = "Plays a single frame of the input based on the value of the control parameter",
    group = "Utilities",
    image = "SingleFrame.png",
    id = generateNamespacedId(idNamespaces.NaturalMotion, 109),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Source"] = {
                       input = true, 
                       array = false,
                       interfaces = {"Transforms", "Time"},
                     },
                     
      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms", "Time"}, 
                   },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    dataPins = 
    {
       ["Control"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
    },
    
    pinOrder = {"Source", "Result", "Control"},
    
    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      { name = "UseTrajectory", type = "bool", value = false },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local inputNode = -1
      local controlNode = -1
      
      if isConnected{SourcePin  = (node .. ".Source"), ResolveReferences = true} then 
        inputNode = getConnectedNodeID(node, "Source")
      end
      if isConnected{SourcePin  = (node .. ".Control"), ResolveReferences = true} then 
        controlNode = getConnectedNodeID(node, "Control")
      end
      local useTrajectory = getAttribute(node, "UseTrajectory")
      
      Stream:writeUInt(inputNode, "InputNodeID")
      Stream:writeUInt(controlNode, "ControlNodeID")
      Stream:writeBool(useTrajectory, "UseTrajectory")
      
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      if isConnected(node..".Source") then
        local nodesConnected = listConnections{Object = (node..".Source"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, "SingleFrame requires a valid input node"
        end
        
      else 
        return nil, ("SingleFrame node " .. node .. " is missing a required connection to Source")
      end
      return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected((node .. ".Source")) then 
        local SourceTable = listConnections{Object = (node .. ".Source"), ResolveReferences = true}
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
    end,

  }

)

------------------------------------------------------------------------------------------------------------------------
-- End of SingleFrame node definition.
------------------------------------------------------------------------------------------------------------------------






