registerNode("TransitionSelect",
  {
    helptext = "Select node for transitions",
    group = "Utilities",
    image = "SelectNodeMatchEvents.png",
    id = generateNamespacedId(idNamespaces.G2, G2NodeTypeNumbers.NodeTypeIOITransitionSelect),
    --------------------------------------------------------------------------------------------------------------------

    dataPins = 
    {
       ["CurrentVelocity"] = {
							input = true, 
							array = false, 
							type = "vector3", 
						},
       ["CurrentFoot"] = {
							input = true, 
							array = false, 
							type = "float", 
						},
       ["TargetVelocity"] = {
							input = true, 
							array = false, 
							type = "vector3", 
						},
       ["TargetRotationOffset"] = {
							input = true, 
							array = false, 
							type = "float", 
						},
       ["TargetPositionOffset"] = {
							input = true, 
							array = false, 
							type = "vector3", 
						},
    },
    
	functionPins = 
	{
		["Source0"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source1"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source2"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source3"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source4"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source5"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source6"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source7"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source8"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source9"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source10"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source11"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source12"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source13"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source14"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source15"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source16"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source17"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source18"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source19"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source20"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source21"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source22"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Source23"] = {
							input = true, 
							array = false,
							interfaces = {"Transforms", "Time", "Events"},
						},
		["Result"] = {
							input = false, 
							array = false, 
							interfaces = {"Transforms", "Time", "Events"}, 
						},
    },
    
    
    pinOrder = {
		"Source0",
		"Source1",
		"Source2",
		"Source3",
		"Source4",
		"Source5",
		"Source6",
		"Source7",
		"Source8",
		"Source9",
		"Source10",
		"Source11",
		"Source12",
		"Source13",
		"Source14",
		"Source15",
		"Source16",
		"Source17",
		"Source18",
		"Source19",
		"Source20",
		"Source21",
		"Source22",
		"Source23",
		"CurrentVelocity",
		"CurrentFoot",
		"TargetVelocity",
		"TargetRotationOffset",
		"TargetPositionOffset",
		"Result" },
    
    --------------------------------------------------------------------------------------------------------------------
	serialize = function(node, Stream)
		Stream:writeUInt(3, "Version")
	
		for nodeIndex=0,23 do
			local nodeID = -1
			nodeName = "Source" .. tostring(nodeIndex)
			if(isConnected{SourcePin = (node .. "." .. nodeName) , ResolveReferences = true}) then
				nodeID = getConnectedNodeID(node, nodeName)
			end
			Stream:writeUInt(nodeID, "IDConnectedTo" .. nodeName )
		end
		
		local nodeID = -1
		if(isConnected{ SourcePin  = (node .. ".CurrentVelocity"), ResolveReferences = true}) then
			nodeID = getConnectedNodeID(node, "CurrentVelocity")
		end
		Stream:writeUInt(nodeID, "IDConnectedToCurrentVelocity")
		
		nodeID = -1
		if isConnected{ SourcePin  = (node .. ".CurrentFoot"), ResolveReferences = true} then
			nodeID = getConnectedNodeID(node, "CurrentFoot")
		end
		Stream:writeUInt(nodeID, "IDConnectedToCurrentFoot")
		
		nodeID = -1
		if isConnected{ SourcePin  = (node .. ".TargetVelocity"), ResolveReferences = true} then
			nodeID = getConnectedNodeID(node, "TargetVelocity")
		end
		Stream:writeUInt(nodeID, "IDConnectedToTargetVelocity")

		nodeID = -1
		if isConnected{ SourcePin  = (node .. ".TargetRotationOffset"), ResolveReferences = true} then
			nodeID = getConnectedNodeID(node, "TargetRotationOffset")
		end
		Stream:writeUInt(nodeID, "IDConnectedToTargetRotationOffset")

		nodeID = -1
		if isConnected{ SourcePin  = (node .. ".TargetPositionOffset"), ResolveReferences = true} then
			nodeID = getConnectedNodeID(node, "TargetPositionOffset")
		end
		Stream:writeUInt(nodeID, "IDConnectedToTargetPositionOffset")
	end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
		if(isConnected{SourcePin  = (node..".Source0"), ResolveReferences = true}) then
			local nodesConnectedTo0 = listConnections{Object = (node..".Source0"), ResolveReferences = true}
			local node0 = nodesConnectedTo0[1]
			if isValid(node0) ~= true then
				return nil, "TransitionSelect requires a valid input node"
			end
		else
			return nil, ("TransitionSelect " .. node .. " is missing a required connection to Source0")
		end
		return true;
	end,
	
	--------------------------------------------------------------------------------------------------------------------
	getTransformChannels = function(node)
		local resultChannels = {} 
		for i=0,23 do
			if(isConnected{SourcePin  = (node .. ".Source" .. tostring(i) ), ResolveReferences = true}) then 
				local SourceTable = listConnections{Object = (node .. ".Source" .. tostring(i)) , ResolveReferences = true}
				local NodeConnectedTo = SourceTable[1]
				resultChannels = setUnion( anim.getTransformChannels(NodeConnectedTo) , resultChannels)
			end
		end
		return resultChannels
	end,
	
	getEvents = function(node)
		return { min = 0, max = 0 }
	end
}
)
