------------------------------------------------------------------------------------------------------------------------
-- TwoBoneIK node definition.
------------------------------------------------------------------------------------------------------------------------

registerNode("TwoBoneIK",
  {
    helptext = "Two-bone IK: make animation reach to a target position and orientation",
    group = "Utilities",
    image = "TwoBoneIK.png",
    id = generateNamespacedId(idNamespaces.NaturalMotion, 120),
    
    --------------------------------------------------------------------------------------------------------------------
    functionPins = 
    {
      ["Source"] = {
                       input = true, 
                       array = false,
                       interfaces = {"Transforms", "Time"},
                     },
                     
      ["Result"] = { 
                     input = false, 
                     array = false, 
                     interfaces = {"Transforms", "Time"}, 
                   },
    },
    
    dataPins = 
    {
        ["EffectorTarget"] = {
                      input = true, 
                      array = false, 
                      type = "vector3", 
                    },
        ["TargetOrientation"] = {
                      input = true, 
                      array = false, 
                      type = "vector4", 
                    },
        ["SwivelAngle"] = {
                      input = true,
                      array = false,
                      type = "float",
                    },
        ["IkFkBlendWeight"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
        ["SwivelContributionToOrientation"] = {
                      input = true, 
                      array = false, 
                      type = "float", 
                    },
    },
    
    pinOrder = {"Source", "Result", "EffectorTarget", "TargetOrientation", "SwivelAngle", "IkFkBlendWeight", "SwivelContribution"},
    
    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      { name = "ReferenceJointIndex", type = "int", value = 0, perAnimSet = true },
      { name = "MidJointRotationAxisX", type = "float", value = 1.0 },
      { name = "MidJointRotationAxisY", type = "float", value = 0 },
      { name = "MidJointRotationAxisZ", type = "float", value = 0 },
      { name = "FlipMidJointRotationDirection", type = "bool", value = false },
      { name = "EndJointIndex", type = "int", value = 0, perAnimSet = true },
      -- Don't actually create attributes for mid and root - currently we are only allowed to use
      -- sequential IK chains, where the mid and root joints are the direct parent and grandparent
      -- of the end joint
      --{ name = "MidJointIndex", type = "int", value = 0 },
      --{ name = "RootJointIndex", type = "int", value = 0 },
      -- For similar reasons, 'assume simple hierarchy' must always be true
      --{ name = "AssumeSimpleHierarchy", type = "bool", value = true },
      { name = "KeepEndEffOrientation", type = "bool", value = true },
      { name = "GlobalReferenceAxis", type = "bool", value = true },
      { name = "MidJointReferenceAxisX", type = "float", value = 0 },
      { name = "MidJointReferenceAxisY", type = "float", value = 0 },
      { name = "MidJointReferenceAxisZ", type = "float", value = 0 },
      { name = "UpdateTargetByDeltas", type = "bool", value = false },
      { name = "EndEffOrientationFromReferenceJoint", type = "bool", value = false },
    },
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(node, Stream)
      local inputNodeID = -1
      local effectorTargetNodeID = -1
      local targetOrientationNodeID = -1
      local swivelAngleNodeID = -1
      local iKFkBlendWeightNodeID = -1
      local swivelContributionToOrientationNodeID = -1

      if isConnected((node .. ".Source") ) then 
        inputNodeID = getConnectedNodeID(node, "Source")
      end
      
      if isConnected((node .. ".EffectorTarget") ) then 
        effectorTargetNodeID = getConnectedNodeID(node, "EffectorTarget")
      end
      
      if isConnected((node .. ".TargetOrientation") ) then 
        targetOrientationNodeID = getConnectedNodeID(node, "TargetOrientation")
      end
      
      if isConnected((node .. ".SwivelAngle") ) then
        swivelAngleNodeID = getConnectedNodeID(node, "SwivelAngle")
      end
      
      if isConnected((node .. ".IkFkBlendWeight") ) then 
        iKFkBlendWeightNodeID = getConnectedNodeID(node, "IkFkBlendWeight")
      end
      
      if isConnected((node .. ".SwivelContributionToOrientation") ) then 
        swivelContributionToOrientationNodeID = getConnectedNodeID(node, "SwivelContributionToOrientation")
      end
      
      
      Stream:writeUInt(inputNodeID, "InputNodeID")
      Stream:writeUInt(effectorTargetNodeID, "effectorTargetPosNodeID")
      Stream:writeUInt(targetOrientationNodeID, "targetOrientationNodeID")
      Stream:writeUInt(swivelAngleNodeID, "swivelAngleNodeID")
      Stream:writeUInt(iKFkBlendWeightNodeID, "ikFkBlendWeightNodeID")
      Stream:writeUInt(swivelContributionToOrientationNodeID, "swivelContributionToOrientationNodeID")
      
      local midJointRotationAxisX = getAttribute(node, "MidJointRotationAxisX")
      Stream:writeFloat(midJointRotationAxisX)
      
      local midJointRotationAxisY = getAttribute(node, "MidJointRotationAxisY")
      Stream:writeFloat(midJointRotationAxisY)
      
      local midJointRotationAxisZ = getAttribute(node, "MidJointRotationAxisZ")
      Stream:writeFloat(midJointRotationAxisZ)
      
      local flipMidJointRotationDirection = getAttribute(node, "FlipMidJointRotationDirection")
      Stream:writeBool(flipMidJointRotationDirection)
      
      local assumeSimpleHierarchy = true --getAttribute(node, "AssumeSimpleHierarchy")
      Stream:writeBool(assumeSimpleHierarchy)

      local keepEndEffOrientation = getAttribute(node, "KeepEndEffOrientation")
      Stream:writeBool(keepEndEffOrientation)

      local endEffOrientationFromReferenceJoint = getAttribute(node, "EndEffOrientationFromReferenceJoint")
      Stream:writeBool(endEffOrientationFromReferenceJoint)

      local globalReferenceAxis = getAttribute(node, "GlobalReferenceAxis")
      Stream:writeBool(globalReferenceAxis)
      
      local midJointReferenceAxisX = getAttribute(node, "MidJointReferenceAxisX")
      Stream:writeFloat(midJointReferenceAxisX)
      
      local midJointReferenceAxisY = getAttribute(node, "MidJointReferenceAxisY")
      Stream:writeFloat(midJointReferenceAxisY)
      
      local midJointReferenceAxisZ = getAttribute(node, "MidJointReferenceAxisZ")
      Stream:writeFloat(midJointReferenceAxisZ)
      
      local updateTargetByDeltas = getAttribute(node, "UpdateTargetByDeltas")
      Stream:writeBool(updateTargetByDeltas)

      local animSets = listAnimSets()
      local numAnimSets = table.getn(animSets)

      Stream:writeUInt(numAnimSets, "NumAnimSets")

      for asIdx, asVal in animSets do
        local endJointIndex = getAttribute(node, "EndJointIndex", asVal)
        Stream:writeUInt(endJointIndex)
      
        -- Don't actually retrieve values for mid and root - currently we are only allowed to use
        -- sequential IK chains, where the mid and root joints are the direct parent and grandparent
        -- of the end joint
        local midJointIndex = -1 --getAttribute(node, "MidJointIndex", asVal)
        Stream:writeUInt(midJointIndex)
      
        local rootJointIndex = -1 --getAttribute(node, "RootJointIndex", asVal)
        Stream:writeUInt(rootJointIndex)

        local referenceJointIndex = getAttribute(node, "ReferenceJointIndex", asVal)
        Stream:writeUInt(referenceJointIndex)
      end

    end,
    
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)

      local inputNode

      -- Validate connections
      if isConnected(node..".Source") then
        local nodesConnected = listConnections(node..".Source")
        inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, ("TwoBoneIK node " .. node .. " requires a valid input node")
        end
        
      else 
        return nil, ("TwoBoneIK node " .. node .. " is missing a required connection to Source")
      end

      
      -- Validate Rig indices
      -- When this node supports non-sequential IK chains, this needs to be expanded
      -- local animSets = listAnimSets()
      -- local numAnimSets = table.getn(animSets)
      -- for asIdx, asVal in animSets do
      --   local index = getConnectedNodeID(node, "EndJointIndex")
      --   local rigSize = anim.getRigSize(asVal)

      --   print(inputNode)
      --   print(asIdx)
      --   local connectedChannels = anim.getTransformChannels(inputNode, asIdx)
      --   for i = 1,3 do
      --     if index == nil or index <= 0 or index >= rigSize then
      --       return nil, ("TwoBoneIK node " .. node .. " (animset " .. asVal .. ") requires a valid EndJointIndex with a valid parent and grandparent")
      --     end

          -- see if the channel is being ouput
      --     local foundChannel = false
      --     for channelIdx, channelVal in connectedChannels do      
      --       if channelVal == index then
      --         foundChannel = true
      --       end
      --     end
          
          -- if not foundChannel then
           -- return nil, ("TwoBoneIK node " .. node .. " (animset " .. asVal .. "): the IK bones are not being output by the input node.")
          -- end
          
      --     index = anim.getParentBoneIndex(index, asVal)
      --   end
      -- end

      if isConnected(node..".SwivelAngle") then
        local nodesConnected = listConnections{Object = (node..".SwivelAngle"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
	  return nil, ("TwoBoneIK node " .. node .. " requires a valid SwivelAngle")
        end
      end

      if isConnected(node..".IkFkBlendWeight") then
        local nodesConnected = listConnections{Object = (node..".IkFkBlendWeight"), ResolveReferences = true} 
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, ("TwoBoneIK node " .. node .. " requires a valid IkFkBlendWeight")
        end
      end

      if isConnected(node..".SwivelContributionToOrientation") then
        local nodesConnected = listConnections{Object = (node..".SwivelContributionToOrientation"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, ("TwoBoneIK node " .. node .. " requires a valid SwivelContributionToOrientation")
        end
      end

      if isConnected(node..".TargetOrientation") then
        local nodesConnected = listConnections{Object = (node..".TargetOrientation"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, ("TwoBoneIK node " .. node .. " requires a valid Target Orientation")
        end
      end

      if isConnected(node..".EffectorTarget") then
        local nodesConnected = listConnections{Object = (node..".EffectorTarget"), ResolveReferences = true}
        local inputNode = nodesConnected[1]
        if isValid(inputNode) ~= true then
          return nil, ("TwoBoneIK node " .. node .. " requires a valid Effector Target")
        end     
      else 
        return nil, ("TwoBoneIK node " .. node .. " is missing a required connection to Effector Target")
      end

      return true
    end,
    
    --------------------------------------------------------------------------------------------------------------------
    getTransformChannels = function(node)
      local inputNodeChannels = {} 
      if isConnected((node .. ".Source")) then 
        local SourceTable = listConnections( (node .. ".Source") )
        local NodeConnected = SourceTable[1]
        inputNodeChannels = anim.getTransformChannels(NodeConnected)
      end

      return inputNodeChannels
    end,

  }

)

------------------------------------------------------------------------------------------------------------------------
-- End of TwoBoneIK node definition.
------------------------------------------------------------------------------------------------------------------------
