------------------------------------------------------------------------------------------------------------------------
-- Transit node definition.
------------------------------------------------------------------------------------------------------------------------

registerTransition("IOITransit",
  {
    -- Input Pin 0: Transform, Time, Trajectory
    -- Input Pin 1: Transform, Time, Trajectory
    -- Output Pin:  Transform, Time, Trajectory
        
    helptext = "Performs a transition blend between two states over a given period of time.",
    interfaces = {"Transforms", "Time"},
    id = generateNamespacedId(idNamespaces.IOI, IOINodeTypeNumbers.NodeTypeIOITransit),
    
    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      {name = "DurationInTime", type = "float", value = 0.5, min = 0.0},                                                                                                                                                      
      {name = "StartDestinationFromBeginning", type = "bool", value = false},
      {name = "BlendFromLastFrame", type = "bool", value = false},
      {name = "IgnoreSourceTrajectory", type = "bool", value = false},     
      
      {name = "EnableRealign", type = "bool", value = false},
    },
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(transition, Stream)
      -- The signature id is used to check wether this node has a version number or not.
      -- ie. if the first uint is SIGNATURE_ID then there is a version number following, else
      -- the first uint is the sourceNodeRuntimeID
	  local SIGNATURE_ID = 1295788826		-- (0x4D3C2B1A) DO NOT EVER CHANGE THIS
	  local version = 2						-- but change this instead if changing the serialization data
	  Stream:writeUInt(SIGNATURE_ID)
	  Stream:writeUInt(version)

      local sourceNodesTable = listConnections{Object= transition, Upstream = true, Downstream = false, ResolveReferences = true}
      local sourceNodeName = sourceNodesTable[1]
      local sourceNodeRuntimeID = getRuntimeID(sourceNodeName)     
      local destNodesTable = listConnections{Object= transition, Upstream = false, Downstream = true, ResolveReferences = true}
      local destNodeName = destNodesTable[1]
      local destNodeRuntimeID = getRuntimeID(destNodeName)    
      
      local durationInTime = getAttribute(transition, "DurationInTime")
      local StartDestinationFromBeginning = getAttribute(transition, "StartDestinationFromBeginning")
      local BlendFromLastFrame = getAttribute(transition, "BlendFromLastFrame")
      local ignoreSourceTrajectory = getAttribute(transition, "IgnoreSourceTrajectory")
        
      Stream:writeUInt(sourceNodeRuntimeID)
      Stream:writeUInt(destNodeRuntimeID)
      Stream:writeFloat(durationInTime)
      Stream:writeBool(StartDestinationFromBeginning)
      Stream:writeBool(BlendFromLastFrame)
      Stream:writeBool(ignoreSourceTrajectory)
      
        -- Transition event info --
  	  local signalTransitionEvents = getAttribute(transition, "EnableRealign")
  	  Stream:writeBool(signalTransitionEvents, "EnableRealign")
      
    end,
   
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      return true
    end,
  }
)

------------------------------------------------------------------------------------------------------------------------
-- End of Transit node definition.
------------------------------------------------------------------------------------------------------------------------
