------------------------------------------------------------------------------------------------------------------------
-- TransitMatchEvents node definition.
------------------------------------------------------------------------------------------------------------------------

registerTransition("TransitMatchEvents",
  {
    -- Input Pin 0: Transform, Time, Trajectory, Events
    -- Input Pin 1: Transform, Time, Trajectory, Events
    -- Output Pin:  Transform, Time, Trajectory, Events
        
    helptext = "Performs a transition blend between two states over a given period of time. Blends and outputs Events.",
    interfaces = {"Transforms", "Time", "Events"},
    id = generateNamespacedId(idNamespaces.NaturalMotion, 401),
    
    --------------------------------------------------------------------------------------------------------------------
    attributes =
    {
      -- It would be ideal if this information was not stored here but rather that we get it from the firing of transition conditions.
      -- This would also allow us to specify sets of either Fractions or EventPositions. We cant currently do this because we have no way of knowing
      -- which one of the set fired the transition.
            
      {name = "DurationInEvents", type = "float", value = 0.5, min = 0.0},  -- How long the transition will last expressed as a number of Events (whole and fractional).

      -- These 2 are mutually exclusive.  
      {name = "DestEventSequenceOffset", type = "int", value = 0, min = 0}, -- Dest starting index is dependent on the starting index of the source.
      {name = "DestStartEventIndex", type = "int", value = 0, min = 0},     -- Dest will always start in this Event range no matter what the Event index in the source. 
      {name = "UsingDestStartEventIndex", type = "bool", value = false},    -- If false, then using DestEventSequenceOffset instead.
            
      {name = "DurationEventBlendPassThrough", type = "bool", value = false},
      {name = "DurationEventBlendInSequence", type = "bool", value = true},
      {name = "DurationEventBlendSameUserData", type = "bool", value = false},
      {name = "DurationEventBlendOnOverlap", type = "bool", value = false},
      {name = "DurationEventBlendWithinRange", type = "bool", value = false},
      
      {name = "IgnoreSourceTrajectory", type = "bool", value = false},

      {name = "EnableRealign", type = "bool", value = false},
    },
    
    --------------------------------------------------------------------------------------------------------------------
    serialize = function(transition, Stream)
      -- The signature id is used to check wether this node has a version number or not.
      -- ie. if the first uint is SIGNATURE_ID then there is a version number following, else
      -- the first uint is the sourceNodeRuntimeID
	  local SIGNATURE_ID = 1295788826		-- (0x4D3C2B1A) DO NOT EVER CHANGE THIS
	  local version = 2						-- but change this instead if changing the serialization data
	  Stream:writeUInt(SIGNATURE_ID)
	  Stream:writeUInt(version)

      local sourceNodesTable = listConnections{Object= transition, Upstream = true, Downstream = false, ResolveReferences = true}
      local sourceNodeName = sourceNodesTable[1]
      local sourceNodeRuntimeID = getRuntimeID(sourceNodeName)
      local destNodesTable = listConnections{Object= transition, Upstream = false, Downstream = true, ResolveReferences = true}
      local destNodeName = destNodesTable[1]
      local destNodeRuntimeID = getRuntimeID(destNodeName)    
     
      local durationInEvents = getAttribute(transition, "DurationInEvents")
      local destEventSequenceOffset = getAttribute(transition, "DestEventSequenceOffset")
      local destStartEventIndex = getAttribute(transition, "DestStartEventIndex")     
      local usingDestStartEventIndex = getAttribute(transition, "UsingDestStartEventIndex")
      local ignoreSourceTrajectory = getAttribute(transition, "IgnoreSourceTrajectory")
     
      Stream:writeUInt(sourceNodeRuntimeID)
      Stream:writeUInt(destNodeRuntimeID)
      Stream:writeFloat(durationInEvents)
      Stream:writeUInt(destEventSequenceOffset)
      Stream:writeUInt(destStartEventIndex)
      Stream:writeBool(usingDestStartEventIndex)
      Stream:writeBool(ignoreSourceTrajectory)
     
      -- Duration event blending flags --
      local durationEventBlendPassThrough = getAttribute(transition, "DurationEventBlendPassThrough")
      local durationEventBlendInSequence = getAttribute(transition, "DurationEventBlendInSequence")
      local durationEventBlendSameUserData = getAttribute(transition, "DurationEventBlendSameUserData")
      local durationEventBlendOnOverlap = getAttribute(transition, "DurationEventBlendOnOverlap")
      local durationEventBlendWithinRange = getAttribute(transition, "DurationEventBlendWithinRange")
      Stream:writeBool(durationEventBlendPassThrough, "DurationEventBlendPassThrough")
      Stream:writeBool(durationEventBlendInSequence, "DurationEventBlendInSequence")
      Stream:writeBool(durationEventBlendSameUserData, "DurationEventBlendSameUserData")
      Stream:writeBool(durationEventBlendOnOverlap, "DurationEventBlendOnOverlap")
      Stream:writeBool(durationEventBlendWithinRange, "DurationEventBlendWithinRange")

      -- Transition event info --
	  local signalTransitionEvents = getAttribute(transition, "EnableRealign")
	  Stream:writeBool(signalTransitionEvents, "EnableRealign")
    end,
   
    --------------------------------------------------------------------------------------------------------------------
    validate = function(node)
      return true
    end,
  }
)

------------------------------------------------------------------------------------------------------------------------
-- End of TransitMatchEvents node definition.
------------------------------------------------------------------------------------------------------------------------
