



-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
-- GLOBAL VARIABLES
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 

PFfile = string.format("%s\\Morpheme_PF_info.txt", os.getenv("temp")) -- Default file name and path to be used for IO info purposes
isResourceServerStarted = false
local resourceIDToFilePathTable = {}
local filePathToResourceIDTable = {}


-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
-- PRIVATE FUNCTIONS
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 

local function SetPaths()
	projectPath = convertResourceIDToFilePath("project:/")
	constructionPath = convertResourceIDToFilePath("construction:/")
	assemblyPath = convertResourceIDToFilePath("assembly:/")
	buildPath = convertResourceIDToFilePath("applications:/")
	
	print("Project Path: "..projectPath)
	print("Construction Path: "..constructionPath)
	print("Assembly Path: "..assemblyPath)
	print("Build Path: "..buildPath)
end

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
-- GLOBAL FUNCTIONS
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 

function runResourceServerCommand0Arg(command)
	--print(string.format("runResourceServerCommand0Arg(%s)", tostring(command)))
	ensureResourceServerStarted()
	local commandLine = string.format("%s/ResourceServerCLI %s >%s", buildPath, command, PFfile)
	--print("Command line: "..commandLine)
	local result = app.execute(commandLine, false, true)
	--print("  Result: "..result)
	--print(string.format("%s", nil)) -- FAKE A LUA ERROR
	return result == 0
end

function runResourceServerCommand1Arg(command, argument)
	--print(string.format("runResourceServerCommand1Arg(%s, %s)", tostring(command), tostring(argument)))
	ensureResourceServerStarted()
	local commandLine = string.format("%s/ResourceServerCLI %s \"%s\" >%s", buildPath, command, argument, PFfile)
	--print("Command line: "..commandLine)
	local result = app.execute(commandLine, false, true)
	--print("  Result: "..result)
	--print(string.format("%s", nil)) -- FAKE A LUA ERROR
	return result == 0
end

function ensureResourceServerStarted()
	if(not isResourceServerStarted) then
		isResourceServerStarted = true
		runResourceServerCommand0Arg("Start")
	end
end

function ensureResourceServerEnded()
	if(isResourceServerStarted) then
		runResourceServerCommand0Arg("End")
		isResourceServerStarted = false
	end
end


function convertResourceIDToFilePath(resourceID)
	local result = resourceIDToFilePathTable[resourceID]
	if(result ~= nil) then
		--print(string.format("Got cached result: '%s' -> '%s' (ResourceID -> FilePath)", tostring(resourceID), tostring(result)))
		return result
	end

	runResourceServerCommand1Arg("ConvertResourceIDToFilePath", resourceID)
	result = nil
	
	for line in io.lines(PFfile) do
		result = line
	end

	--print("convertFilePathToResourceID " .. result)
	resourceIDToFilePathTable[resourceID] = result
	return result
end

function convertFilePathToResourceID(filePath)
	local result = filePathToResourceIDTable[filePath]
	if(result ~= nil) then
		print(string.format("Got cached result: '%s' -> '%s' (FilePath -> ResourceID)", tostring(filePath), tostring(result)))
		return result
	end
	
	runResourceServerCommand1Arg("ConvertFilePathToResourceID", filePath)
	result = io.lines(PFfile)()
	print("convertFilePathToResourceID " .. result)
	filePathToResourceIDTable[filePath] = result
	return result
end

-- --
-- Updates a resource on disk or creates it, if it does not exist already.
-- --
function BuildResource(derivedResourceID)
	return runResourceServerCommand1Arg("LoadResource", derivedResourceID)	
end

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
SetPaths()
