local previewRig = ""
local exportRig = ""


-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 
-- PRIVATE FUNCTIONS
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 

local function IsValidRigPath(rigPath)
	if((string.find(rigPath, ".xml", 1, true) == nil)) then
		return false
	end	
	
	return true
end


local function RigPrimExists(rigPath)
	
	local absRigPath = utils.demacroizeString(rigPath)
	local absPrimPath = string.gsub(absRigPath, "~.*~", "") -- Strip the tilde and everyting in between
	absPrimPath = string.gsub(absPrimPath, "%..*", ".wl2") -- Replace the extension with wl2
	
	-- Check if the file exists by opening it.
	fh = io.open(absPrimPath, "rb")
	if(fh ~= nil) then
		fh:close()
		return true
	else
		return false
	end
end


-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- PUBLIC FUNCTIONS
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

-- Load the rig info associated with the current network (mcn file)
function LoadRigPaths(mcnFileName)
	LoadPreviewRig()
	LoadExportRig()
end


-- Save the export rig info for the current network.
function SaveExportRigPath(newExportRig)
	if(not IsValidRigPath(newExportRig)) then
		return false, string.format("Export rig path \"%s\" is invalid.", newExportRig)
	end
	
	local rigSaved = SaveExportRig()
	if(not rigSaved) then
		return false, string.format("Failed to save export rig path \"%s\".", newExportRig)
	end
	
	return true
end


function SavePreviewRigPath(newPreviewRig)
	if(not IsValidRigPath(newPreviewRig)) then
		return false, string.format("Preview rig path \"%s\" is invalid.", newPreviewRig)
	end
	
	local rigSaved = SavePreviewRig()
	if(not rigSaved) then
		return false, string.format("Failed to save preview rig path \"%s\".", newPreviewRig)
	end
	
	return true
end


function GetRigPaths()
	return previewRig, exportRig
end

function GetPreviewRigPath()
	return previewRig
end

function GetExportRigPath()
	return exportRig
end

function SetPreviewRig(previewRigPath)
	
	if(not RigPrimExists(previewRigPath)) then
		ReportWarning("You are currently setting a rig, for which no primitive data exists.\nDeformation bone calculations, facial animation and retargeting will be disabled!")
	end
	
	previewRig = previewRigPath
	-- Set the preview rig as rig for the default anim set
	local success = anim.setRigPath(utils.macroizeString(previewRigPath))
	if(not success) then
		return false
	end
	
	mcn.commit("Preview rig set for default anim set")
	return true
end

function SetExportRig(exportRigPath)
	exportRig = exportRigPath
	return true
end

function SetDefaultRigInfo()
	SetPreviewRig(defaultPreviewRig)
	SetExportRig(defaultExportRig)
end
