-- --
-- Custom IOI Morpheme Connect startup script.
-- This is automatically run by Morpehme Connect and boot straps the rest of our customisations in the _out folder.

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- 

function executeSingleScript(fileName)
	print(string.format("Loading file - %s", fileName))
	local result, err = pcall(dofile, fileName)
	if (result ~= true) then
		print(string.format("Error executing script: %s", err))
	end
end

-- This function selects an animation in the animation browser based on the animation used by the currently selected node
function SelectAnimFromFirstNode()
	
	local selection = ls("Selection")
	local firstNode = selection[1]
	if (firstNode == nil) then
		return
	end
	
	local nodeType = getType(firstNode)
	if(nodeType == "AnimWithEvents" or nodeType == "IOIAnim" or nodeType == "IOIVariation") then
		local animationTake = {}
		if(nodeType ~= "IOIVariation") then
			animationTake = getAttribute(firstNode, "AnimationTake")
		else
			local variationName = getAttribute(firstNode, "VariationName")
			local variationEntry = GetVariationEntry(variationName)
			if(variationEntry ~= nil) then
				animationTake = { filename = variationEntry.AnimPath, takename = variationEntry.TakeName }
			else
				ReportError("Could not find variation entry " .. variationName .."! Did you select the right animset?")
			end
		end
		anim.selectTakeInBrowser(animationTake)
	end
end

-- This function overrides the one declared in the normal NM startup script to include our custom animation node type
local function onSelectionChange(nodes)
	SelectAnimFromFirstNode()
end

local function printPreferences()
	print("Preferences:")
	print("------------")
	print("Build Path: "..buildPath)
	print("Root Dir: "..rootDir)
	print("Anim Source Dir: "..animSourceDir)
	print("Markup Dir: "..markupDir)
	print("Default Preview Rig: "..defaultPreviewRig)
	print("Default Export Rig: "..defaultExportRig)
	print("Default Anim Database Path: "..defaultAnimDataBasePath)
	print("Default Character Type: "..defaultCharacterType)
end

registerEventHandler("mcSelectionChange", onSelectionChange)

-- The custom ui functionality has not been initialized yet, so we need a little custom function here to show error messages
local function simpleDialogue(caption, bodyText)
	local sizer = dialog.makeSizer(nil, false)
	dialog.makeStaticText(bodyText, sizer)
	dialog.makeOKbutton("OK", sizer, 0.0, false, 2.0)
	local dlg = dialog.create(caption, sizer)
	dialog.showModal(dlg)
end

-- Get the project settings
if(app.execute("\"" .. app.getAppExecutableDir() .."IOI_binaries\\MorphemeInit.exe\"", false, true) == 0) then
	infoFilePath = string.format("%s\\F1829F5C-0F02-43e8-AEB6-874F664BA10C.txt", os.getenv("temp"))
	infoFile, err = io.open(infoFilePath)
	if (infoFile ~= nil) then
		buildPath = infoFile:read()
		
		rootDir = infoFile:read()
		animSourceDir = infoFile:read()
		markupDir = infoFile:read()
		defaultPreviewRig = infoFile:read()
		defaultExportRig = infoFile:read()
		
		defaultAnimDataBasePath = infoFile:read()
		defaultCharacterType = infoFile:read()

		infoFile:close()
		os.remove(infoFilePath)
		
		--printPreferences()
		executeSingleScript(string.format("%s\\morpheme\\scripts\\g2startup.lua", buildPath))
	else
		simpleDialogue("Error", string.format("Could not open paths info file. MorphemeInit possibly failed.\n%s\n\n", err))
	end
else
	simpleDialogue("Error", "Could not launch MorphemeInit.exe\nG2 custom functionality will be unavailable.\n\n")
end