-- Define global dialogue button types, so that they can be used from other scripts
BUTTON_OK_CANCEL	= 1
BUTTON_OK_ONLY		= 2
BUTTON_YES_NO		= 3

local dialogueButtonFunctions = 
{
	[BUTTON_OK_CANCEL]	= function(dialog, sizer) dialog.makeStandardOKCancel(sizer) end,
	[BUTTON_OK_ONLY]	= function(dialog, sizer) dialog.makeOKbutton("OK", sizer, 0.0, false, 2.0) end,
	[BUTTON_YES_NO]		= function(dialog, sizer) local yesNoSizer = dialog.makeSizer(sizer, true, 0.0, true, 0.0)
													dialog.makeOKbutton("Yes", yesNoSizer, 0.0, false, 2.0)
													dialog.makeCancelButton("No", yesNoSizer, 0.0, false, 2.0) end
}

-- --
-- Dialogue creation encapsulation
-- --
function ShowDialogue(caption, bodyText, buttonType)
	local sizer = dialog.makeSizer(nil, false)
	dialog.makeStaticText(bodyText, sizer)
	dialogueButtonFunctions[buttonType](dialog, sizer)
	local dlg = dialog.create(caption, sizer)
	return dialog.showModal(dlg)
end

-- --
-- Simple error report dialogue based on ShowDialogue
-- --
function ReportError(message)
	app.log(string.format("ERROR: %s", message))
	--app.log(debug.traceback())
	ShowDialogue("ERROR", string.format("ERROR: %s\n\n", message), BUTTON_OK_ONLY)
end

-- --
-- Simple warning report dialogue based on ShowDialogue
-- --
function ReportWarning(message)
	app.log(string.format("WARNING: %s", message))
	ShowDialogue("WARNING", string.format("WARNING: %s\n\n", message), BUTTON_OK_ONLY)
end
