@echo off

:: Get absolutes paths to cloud dir & buildroot
set REL_PATH=..\
set _EGS_ROOT=
pushd %REL_PATH%
set _EGS_ROOT=%CD%
popd
set REL_PATH="..\..\OriginalPackages\EGS\Chunks\"
set cloudDir=
pushd %REL_PATH%
set cloudDir=%CD%
popd


set _VERSION_OPTION=Generic
if %1==-beta set _VERSION_OPTION=-beta

for %%a in ("%~dp0\..\..") do set "TargetBuild=%%~nxa"

echo The version option is %_VERSION_OPTION%
echo The target build is %TargetBuild%
echo the build root is %_EGS_ROOT%

set executable=%_EGS_ROOT%\ContentFiles\Steelrising.exe
if exist "%executable%" set TARGET_EXECUTABLE="ContentFiles/Steelrising.exe"
if not exist "%executable%" set TARGET_EXECUTABLE="ContentFiles/SteelrisingDO.exe"

echo Executable selected = %TARGET_EXECUTABLE%

set BuilPatchExe="BuildPatchTool_1.5.0.1\Engine\Binaries\Win64\BuildPatchTool.exe"
set TargetLabel="Live"
set EGS_LOGIN_FILE=%_EGS_ROOT%\egs_login.txt
set EGS_LOGIN_FILE_ALT=%USERPROFILE%\Documents\Steelrising_Build\EGS\Generic\Config\egs_login.txt
if exist %EGS_LOGIN_FILE_ALT% set EGS_LOGIN_FILE=%EGS_LOGIN_FILE_ALT%

:: Get secret IDs
for /F "tokens=1,2 delims=:" %%a in (%EGS_LOGIN_FILE%) do (
call :SetVar %%a %%b
)
goto Process

:SetVar
if %1 == OrgId (
		set OrgId=%2
	)
	if  %1 == productId (
		set productId=%2
	)
	if  %1 == ClientId (
		set ClientId=%2
	)
	if  %1 == ClientSecret (
		set ClientSecret=%2
	)
	if %_VERSION_OPTION%==-beta if %1 == ArtifactIdBeta (
		set ArtifactId=%2
		echo Using ArtifactId from Beta : %2
	)
	if %_VERSION_OPTION%==Generic if %1 == ArtifactId (
		set ArtifactId=%2
		echo Using ArtifactId from Generic : %2
	)


goto eof

:Process


:: Build and upload
call %BuilPatchExe% -OrganizationId=%OrgId% -ProductId=%ProductId% -ArtifactId=%ArtifactId% -ClientId=%ClientId% -ClientSecret=%ClientSecret% -mode=PatchGeneration -BuildRoot=%_EGS_ROOT% -CloudDir=%cloudDir% -BuildVersion=%TargetBuild% -AppLaunch=%TARGET_EXECUTABLE% -AppArgs="-errors=0"

if %ERRORLEVEL%==2 (
echo Binary with this label already found : deleting previous
call %BuilPatchExe% -OrganizationId=%OrgId% -ProductId=%ProductId% -ArtifactId=%ArtifactId% -ClientId=%ClientId% -ClientSecret=%ClientSecret% -mode=UnlabelBinary -BuildVersion=%TargetBuild% -Platform="Windows" -label=%TargetLabel%
call %BuilPatchExe% -OrganizationId=%OrgId% -ProductId=%ProductId% -ArtifactId=%ArtifactId% -ClientId=%ClientId% -ClientSecret=%ClientSecret% -mode=DeleteBinary -BuildVersion=%TargetBuild%
call %BuilPatchExe% -OrganizationId=%OrgId% -ProductId=%ProductId% -ArtifactId=%ArtifactId% -ClientId=%ClientId% -ClientSecret=%ClientSecret% -mode=PatchGeneration -BuildRoot=%_EGS_ROOT% -CloudDir=%cloudDir% -BuildVersion=%TargetBuild% -AppLaunch=%TARGET_EXECUTABLE% -AppArgs="-errors=0"
)

:: Set Live (can be download and launched)
call %BuilPatchExe% -OrganizationId=%OrgId% -ProductId=%ProductId% -ArtifactId=%ArtifactId% -ClientId=%ClientId% -ClientSecret=%ClientSecret% -mode=LabelBuild -BuildVersion=%TargetBuild% -Platform="Windows" -label=%TargetLabel%


pause

:eof