@echo off
REM "This batch file will build a complete RenderWare release, and copy the"
REM "relevant files to the correct place."
REM "----------------------------------------------------------------------"
REM "Usage:"

REM "buildrel <dirspec>"

REM "<dirspec> specifies where the resultant release should go."
REM "<dirspec> should already exist.  The release will be created"
REM "within this directory."

if "%1" == "" goto usage

REM ************************
REM *** MAKE OPTIONS.MAK ***
REM ************************

echo Making options.mak

if exist options.saf goto dontmoveoptions
move options.mak options.saf

:dontmoveoptions
echo COPTIMIZE=1 >> options.mak
echo CDEBUG=0 >> options.mak
echo WORLDTOOLBOX=1 >> options.mak
echo RWCOMPILER=visualc >> options.mak
echo RWOS=win >> options.mak
echo DXSDK=D:/mssdk >> options.mak
echo GLIDE=D:/3DFX/glide >> options.mak

REM ***************************
REM *** BUILD THE LIBRARIES ***
REM ***************************

echo Building libraries...

REM CLEANOUT - This provides a dummy target, but it's not important
REM We still have to do a make clean per target to clean out the obj dirs

bin\gnumake RWTARGET=null distclean

echo D3D release build                             >> buildlog.txt
echo =================                             >> buildlog.txt
echo                                               >> buildlog.txt
bin\gnumake RWTARGET=d3d RWDEBUG=0 clean
bin\gnumake RWTARGET=d3d RWDEBUG=0                 >> buildlog.txt
echo                                               >> buildlog.txt

echo D3D debug build                               >> buildlog.txt
echo ===============                               >> buildlog.txt
echo                                               >> buildlog.txt
bin\gnumake RWTARGET=d3d RWDEBUG=1 clean
bin\gnumake RWTARGET=d3d RWDEBUG=1                 >> buildlog.txt
echo                                               >> buildlog.txt

echo 3DFX release build                            >> buildlog.txt
echo ==================                            >> buildlog.txt
echo                                               >> buildlog.txt
bin\gnumake RWTARGET=3dfx RWDEBUG=0 clean
bin\gnumake RWTARGET=3dfx RWDEBUG=0                >> buildlog.txt
echo                                               >> buildlog.txt

echo 3DFX debug build                              >> buildlog.txt
echo ================                              >> buildlog.txt
echo                                               >> buildlog.txt
bin\gnumake RWTARGET=3dfx RWDEBUG=1 clean
bin\gnumake RWTARGET=3dfx RWDEBUG=1                >> buildlog.txt
echo                                               >> buildlog.txt

:dontbuildlib

REM ********************************
REM *** MAKE DIRECTORY STRUCTURE ***
REM ********************************

echo Making release directory structure...

mkdir %1\rwsdk
mkdir %1\rwsdk\samples
mkdir %1\rwsdk\samples\immemode
mkdir %1\rwsdk\samples\immemode\src\
mkdir %1\rwsdk\samples\immemode\src\chrlitte
mkdir %1\rwsdk\samples\immemode\src\chrtorus
mkdir %1\rwsdk\samples\immemode\src\colcube
mkdir %1\rwsdk\samples\immemode\src\common
mkdir %1\rwsdk\samples\immemode\src\common\dumb
mkdir %1\rwsdk\samples\immemode\src\common\windows
mkdir %1\rwsdk\samples\immemode\src\earth
mkdir %1\rwsdk\samples\immemode\src\flatorus
mkdir %1\rwsdk\samples\immemode\src\fog
mkdir %1\rwsdk\samples\immemode\src\littea
mkdir %1\rwsdk\samples\immemode\src\mask
mkdir %1\rwsdk\samples\immemode\src\pipeover
mkdir %1\rwsdk\samples\immemode\src\spheralp
mkdir %1\rwsdk\samples\immemode\src\sphere
mkdir %1\rwsdk\samples\immemode\src\sphertex
mkdir %1\rwsdk\samples\immemode\src\squashad
mkdir %1\rwsdk\samples\immemode\src\squawire
mkdir %1\rwsdk\samples\immemode\src\teapot
mkdir %1\rwsdk\samples\immemode\textures
mkdir %1\rwsdk\samples\immemode\src\torus
mkdir %1\rwsdk\samples\immemode\src\trancube
mkdir %1\rwsdk\samples\immemode\src\triangle
mkdir %1\rwsdk\samples\immemode\src\tritex
mkdir %1\rwsdk\samples\immemode\src\tritex2d
mkdir %1\rwsdk\samples\immemode\src\textures
mkdir %1\rwsdk\samples\kaleido
mkdir %1\rwsdk\samples\kaleido\src
mkdir %1\rwsdk\samples\kaleido\src\win
mkdir %1\rwsdk\samples\kaleido\textures
mkdir %1\rwsdk\samples\kaleido\textures\backdrop
mkdir %1\rwsdk\samples\ghost
mkdir %1\rwsdk\samples\ghost\src
mkdir %1\rwsdk\samples\ghost\src\win
mkdir %1\rwsdk\samples\ghost\windows
mkdir %1\rwsdk\samples\ghost\models
mkdir %1\rwsdk\samples\ghost\misc
mkdir %1\rwsdk\samples\ghost\textures
mkdir %1\rwsdk\samples\rwview
mkdir %1\rwsdk\samples\rwview\src
mkdir %1\rwsdk\samples\rwview\textures
mkdir %1\rwsdk\samples\rwview\models
mkdir %1\rwsdk\samples\space
mkdir %1\rwsdk\samples\space\src
mkdir %1\rwsdk\samples\space\src\win
mkdir %1\rwsdk\samples\space\models
mkdir %1\rwsdk\samples\space\textures
mkdir %1\rwsdk\samples\stereo
mkdir %1\rwsdk\tools
mkdir %1\rwsdk\tools\3dsmax
mkdir %1\rwsdk\tools\misc
mkdir %1\rwsdk\doc
mkdir %1\rwsdk\include
mkdir %1\rwsdk\include\d3d
mkdir %1\rwsdk\include\3dfx
mkdir %1\rwsdk\lib
mkdir %1\rwsdk\lib\d3d
mkdir %1\rwsdk\lib\d3d\debug
mkdir %1\rwsdk\lib\3dfx
mkdir %1\rwsdk\lib\3dfx\debug

REM **************************
REM *** COPY LIBRARY FILES ***
REM **************************

echo "Copying library files..."
copy lib\d3d\*.lib %1\rwsdk\lib\d3d
copy lib\d3d\debug\*.lib %1\rwsdk\lib\d3d\debug
copy lib\3dfx\*.lib %1\rwsdk\lib\3dfx
copy lib\3dfx\debug\*.lib %1\rwsdk\lib\3dfx\debug

REM ******************
REM *** COPY TOOLS ***
REM ******************

echo "Copying tools..."
copy ..\app\maxplugins\rw30exp\rw30exp.dle %1\rwsdk\tools\3dsmax
copy ..\app\misc\rwsview.exe %1\rwsdk\tools\misc

REM *************************
REM *** COPY HEADER FILES ***
REM *************************

echo "Copying header files..."
copy include\d3d\*.h %1\rwsdk\include\d3d
copy include\d3d\*.def %1\rwsdk\include\d3d
copy include\d3d\*.rpe %1\rwsdk\include\d3d
copy include\3dfx\*.h %1\rwsdk\include\3dfx
copy include\3dfx\*.def %1\rwsdk\include\3dfx
copy include\3dfx\*.rpe %1\rwsdk\include\3dfx

REM **************************
REM *** COPY DOCUMENTATION ***
REM **************************

echo Copying documentation...

copy docs\reference\*.pdf %1\rwsdk\doc
copy readme.txt %1\rwsdk
copy changes.pdf %1\rwsdk

REM ******************
REM *** COPY DEMOS ***
REM ******************

copy ..\app\demo\kaleido\src\*.c %1\rwsdk\samples\kaleido\src
copy ..\app\demo\kaleido\src\*.h %1\rwsdk\samples\kaleido\src
copy ..\app\demo\kaleido\src\win\*.c %1\rwsdk\samples\kaleido\src\win
copy ..\app\demo\kaleido\src\win\*.rc %1\rwsdk\samples\kaleido\src\win
copy ..\app\demo\kaleido\makefile %1\rwsdk\samples\kaleido
copy ..\app\demo\kaleido\*.txt %1\rwsdk\samples\kaleido
copy ..\app\demo\kaleido\textures\*.* %1\rwsdk\samples\kaleido\textures
copy ..\app\demo\kaleido\textures\backdrop\*.* %1\rwsdk\samples\kaleido\textures\backdrop

copy ..\app\demo\ghost\makefile %1\rwsdk\samples\ghost
copy ..\app\demo\ghost\readme.txt %1\rwsdk\samples\ghost
copy ..\app\demo\ghost\src\*.c %1\rwsdk\samples\ghost\src
copy ..\app\demo\ghost\src\*.h %1\rwsdk\samples\ghost\src
copy ..\app\demo\ghost\src\win\*.c %1\rwsdk\samples\ghost\src\win
copy ..\app\demo\ghost\src\win\*.h %1\rwsdk\samples\ghost\src\win
copy ..\app\demo\ghost\models\*.* %1\rwsdk\samples\ghost\models
copy ..\app\demo\ghost\textures\*.bmp %1\rwsdk\samples\ghost\textures

copy ..\app\demo\rwview\src\*.c %1\rwsdk\samples\rwview\src
copy ..\app\demo\rwview\src\*.h %1\rwsdk\samples\rwview\src
copy ..\app\demo\rwview\makefile %1\rwsdk\samples\rwview
copy ..\app\demo\rwview\src\*.rc %1\rwsdk\samples\rwview\src
copy ..\app\demo\rwview\*.txt %1\rwsdk\samples\rwview
copy ..\app\demo\rwview\models\*.* %1\rwsdk\samples\rwview\models
copy ..\app\demo\rwview\textures\*.* %1\rwsdk\samples\rwview\textures

copy ..\app\demo\space\src\*.c %1\rwsdk\samples\space\src
copy ..\app\demo\space\src\win\*.c %1\rwsdk\samples\space\src\win
copy ..\app\demo\space\src\*.h %1\rwsdk\samples\space\src
copy ..\app\demo\space\makefile %1\rwsdk\samples\space
copy ..\app\demo\space\*.txt %1\rwsdk\samples\space
copy ..\app\demo\space\models\*.* %1\rwsdk\samples\space\models
copy ..\app\demo\space\textures\*.* %1\rwsdk\samples\space\textures

copy plugin\stereo\*.c %1\rwsdk\samples\stereo
copy plugin\stereo\*.h %1\rwsdk\samples\stereo
copy plugin\stereo\*.def %1\rwsdk\samples\stereo
copy plugin\stereo\makefile %1\rwsdk\samples\stereo
copy src\rwdbgerr.c %1\rwsdk\samples\stereo
copy src\rwdbgerr.h %1\rwsdk\samples\stereo

copy ..\app\demo\immemode\makefile %1\rwsdk\samples\immemode
copy ..\app\demo\immemode\src\chrlitte\*.c  %1\rwsdk\samples\immemode\src\chrlitte
copy ..\app\demo\immemode\src\chrtorus\*.c %1\rwsdk\samples\immemode\src\chrtorus
copy ..\app\demo\immemode\src\colcube\*.c %1\rwsdk\samples\immemode\src\colcube
copy ..\app\demo\immemode\src\common\*.c %1\rwsdk\samples\immemode\src\common
copy ..\app\demo\immemode\src\common\*.h %1\rwsdk\samples\immemode\src\common
copy ..\app\demo\immemode\src\common\win\*.c %1\rwsdk\samples\immemode\src\common\win
copy ..\app\demo\immemode\src\earth\*.c %1\rwsdk\samples\immemode\src\earth
copy ..\app\demo\immemode\src\flatorus\*.c %1\rwsdk\samples\immemode\src\flatorus
copy ..\app\demo\immemode\src\fog\*.c %1\rwsdk\samples\immemode\src\fog
copy ..\app\demo\immemode\src\littea\*.c %1\rwsdk\samples\immemode\src\littea
copy ..\app\demo\immemode\src\mask\*.c %1\rwsdk\samples\immemode\src\mask
copy ..\app\demo\immemode\src\pipeover\*.c %1\rwsdk\samples\immemode\src\pipeover
copy ..\app\demo\immemode\src\spheralp\*.c %1\rwsdk\samples\immemode\src\spheralp
copy ..\app\demo\immemode\src\sphere\*.c %1\rwsdk\samples\immemode\src\sphere
copy ..\app\demo\immemode\src\sphertex\*.c %1\rwsdk\samples\immemode\src\sphertex
copy ..\app\demo\immemode\src\squashad\*.c %1\rwsdk\samples\immemode\src\squashad
copy ..\app\demo\immemode\src\squawire\*.c %1\rwsdk\samples\immemode\src\squawire
copy ..\app\demo\immemode\src\teapot\*.c %1\rwsdk\samples\immemode\src\teapot
copy ..\app\demo\immemode\textures\*.* %1\rwsdk\samples\immemode\textures
copy ..\app\demo\immemode\src\torus\*.c %1\rwsdk\samples\immemode\src\torus
copy ..\app\demo\immemode\src\trancube\*.c %1\rwsdk\samples\immemode\src\trancube
copy ..\app\demo\immemode\src\triangle\*.c %1\rwsdk\samples\immemode\src\triangle
copy ..\app\demo\immemode\src\tritex\*.c %1\rwsdk\samples\immemode\src\tritex
copy ..\app\demo\immemode\src\tritex2d\*.c %1\rwsdk\samples\immemode\src\tritex2d

REM ********************************
REM *** BUILD AND COPY DEMO EXEs ***
REM ********************************

cd ..\app\demo\immemode

gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk clean
gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk       >> ..\..\..\rwsdk\buildlog.txt
copy chrlitte.exe %1\rwsdk\samples\immemode\chrlitte_d3d.exe
copy chrtorus.exe %1\rwsdk\samples\immemode\chrtorus_d3d.exe
copy colcube.exe %1\rwsdk\samples\immemode\colcube_d3d.exe
copy earth.exe %1\rwsdk\samples\immemode\earth_d3d.exe
copy flatorus.exe %1\rwsdk\samples\immemode\flatorus_d3d.exe
copy fog.exe %1\rwsdk\samples\immemode\fog_d3d.exe
copy littea.exe %1\rwsdk\samples\immemode\littea_d3d.exe
copy mask.exe %1\rwsdk\samples\immemode\mask_d3d.exe
copy sphere.exe %1\rwsdk\samples\immemode\sphere_d3d.exe
copy sphertex.exe %1\rwsdk\samples\immemode\sphertex_d3d.exe
copy squashad.exe %1\rwsdk\samples\immemode\squashad_d3d.exe
copy squawire.exe %1\rwsdk\samples\immemode\squawire_d3d.exe
copy teapot.exe %1\rwsdk\samples\immemode\teapot_d3d.exe
copy torus.exe %1\rwsdk\samples\immemode\torus_d3d.exe
copy trancube.exe %1\rwsdk\samples\immemode\trancube_d3d.exe
copy triangle.exe %1\rwsdk\samples\immemode\triangle_d3d.exe
copy tritex.exe %1\rwsdk\samples\immemode\tritex_d3d.exe
copy tritex2d.exe %1\rwsdk\samples\immemode\tritex2d_d3d.exe

gnumake RWTARGET=3dfx RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk clean
gnumake RWTARGET=3dfx RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk       >> ..\..\..\rwsdk\buildlog.txt
copy chrlitte.exe %1\rwsdk\samples\immemode\chrlitte_fx.exe
copy chrtorus.exe %1\rwsdk\samples\immemode\chrtorus_fx.exe
copy colcube.exe %1\rwsdk\samples\immemode\colcube_fx.exe
copy earth.exe %1\rwsdk\samples\immemode\earth_fx.exe
copy flatorus.exe %1\rwsdk\samples\immemode\flatorus_fx.exe
copy fog.exe %1\rwsdk\samples\immemode\fog_fx.exe
copy littea.exe %1\rwsdk\samples\immemode\littea_fx.exe
copy mask.exe %1\rwsdk\samples\immemode\mask_fx.exe
copy sphere.exe %1\rwsdk\samples\immemode\sphere_fx.exe
copy sphertex.exe %1\rwsdk\samples\immemode\sphertex_fx.exe
copy squashad.exe %1\rwsdk\samples\immemode\squashad_fx.exe
copy squawire.exe %1\rwsdk\samples\immemode\squawire_fx.exe
copy teapot.exe %1\rwsdk\samples\immemode\teapot_fx.exe
copy torus.exe %1\rwsdk\samples\immemode\torus_fx.exe
copy trancube.exe %1\rwsdk\samples\immemode\trancube_fx.exe
copy triangle.exe %1\rwsdk\samples\immemode\triangle_fx.exe
copy tritex.exe %1\rwsdk\samples\immemode\tritex_fx.exe
copy tritex2d.exe %1\rwsdk\samples\immemode\tritex2d_fx.exe

cd ..\kaleido

gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk clean
gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk       >> ..\..\..\rwsdk\buildlog.txt
copy kaleid.exe %1\rwsdk\samples\kaleido\kaleid_d3d.exe

gnumake RWTARGET=3dfx RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk clean
gnumake RWTARGET=3dfx RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk       >> ..\..\..\rwsdk\buildlog.txt
copy kaleid.exe %1\rwsdk\samples\kaleido\kaleid_3dfx.exe

cd ..\ghost

gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk clean
gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk       >> ..\..\..\rwsdk\buildlog.txt
copy redfly.exe %1\rwsdk\samples\ghost\redfly_d3d.exe

gnumake RWTARGET=3dfx RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk clean
gnumake RWTARGET=3dfx RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk       >> ..\..\..\rwsdk\buildlog.txt
copy redfly.exe %1\rwsdk\samples\ghost\redfly_3dfx.exe

cd ..\rwview

gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk clean
gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk       >> ..\..\..\rwsdk\buildlog.txt
copy rwview.exe %1\rwsdk\samples\rwview\rwview_d3d.exe

cd ..\space

gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk clean
gnumake RWTARGET=d3d RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk       >> ..\..\..\rwsdk\buildlog.txt
copy space.exe %1\rwsdk\samples\space\space_d3d.exe

gnumake RWTARGET=3dfx RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk clean
gnumake RWTARGET=3dfx RWCOMPILER=visualc RWOS=win RWSDK=..\..\..\rwsdk       >> ..\..\..\rwsdk\buildlog.txt
copy space.exe %1\rwsdk\samples\space\space_3dfx.exe

cd ..\..\..\rwsdk

REM ***************
REM *** TIDY UP ***
REM ***************

move options.saf options.mak

goto exit

:usage
echo "Usage: buildrel <dirspec>"
echo ""
echo "Makes RenderWare release tree under <dirspec>."
echo "<dirspec> should already exist."
goto exit

:exit
