
/***************************************************************************
 *                                                                         *
 * Module  : banull.h                                                      *
 *                                                                         *
 * Purpose : NULL device header                                            *
 *                                                                         *
 **************************************************************************/

#ifndef RWNULL_H
#define RWNULL_H

/****************************************************************************
 Includes
 */

/****************************************************************************
 Defines
 */
#define RASTEREXTFROMRASTERCONST(raster) \
    ((const _SkyRasterExt *)(((const RwUInt8 *)(raster)) + skyRasterExt))
#define RASTEREXTFROMRASTER(raster) \
    ((_SkyRasterExt *)(((RwUInt8 *)(raster)) + skyRasterExt))

#define TWIDDLEEIGHT
#define ALTTEXFORM

/****************************************************************************
 Global Types
 */

typedef struct _SkyRasterExt _SkyRasterExt;
struct _SkyRasterExt
{
    RwInt32           dmaRefCount;
    RwInt32           dmaClrCount;

    /* General texture setup register */
    RwUInt32          lsb;
    RwUInt32          msb;
    RwUInt32          palOffset;

    RwUInt16          mipmapKL;      /* K: a 12 bit 8.4 value in bottom bits */
                                     /* L: a 2 bit value in 12,13 */ 
    RwUInt8           maxMipLevel;  /* NOTE: This is left shifted two */
    RwUInt8           bLocked;          /* Is this texture to stay in the cache? */

    /* Mipmap addresses */
    RwUInt32          miptbp1Lsb, miptbp1Msb;
    RwUInt32          miptbp2Lsb, miptbp2Msb;

    RwUInt32          sysMemSize;     /* Size in bytes in system memory for pixels */
    RwUInt32          sysMemPalSize;  /* Size in bytes in system memory for palette */

    RwUInt32          nTexCacheSize;  /* Size in words in video memory for pixels + palette */
    
    RwUInt8           cachePkts;         /* Should we cache packets for this raster */
    RwUInt8           lockedMipLevel;    /* Currently locked mip level */
    RwUInt8           flags;             /* Bit 0 new format texture */
    RwUInt8           pad[1];
    /* u_long128 */ void        *palUploadPkt;     /* Cached packet for uploading the palette */
    /* u_long128 */ void        *mipUploadPkts[7]; /* Cached packets for uploading the mip levels */

    /* _SkyMemBlock  */ void    *mpCacheEntry;  /* The memory block that currently holds this texture */ 
#if defined(GSB) && defined(GSPLUS)
    RwUInt32          lsb3;
    RwUInt32          msb3;
    RwUInt32          miptbp3Lsb, miptbp3Msb;
    RwUInt32          miptbp4Lsb, miptbp4Msb;
#endif /* defined(GSB) && defined(GSPLUS) */
};


/****************************************************************************
 Function prototypes
 */

#ifdef    __cplusplus
extern          "C"
{
#endif         /* __cplusplus */

extern RwInt32 skyRasterExt;

extern RwInt32 _rwSkyFindMSB(RwUInt32 nInt);

#ifdef    __cplusplus
}
#endif         /* __cplusplus */

#endif         /* RWNULL_H */
