#ifndef _DMAMACROS_H
#define _DMAMACROS_H

#define sweInlineDmaSync(dmaChan) \
do \
{ \
    while ((*(volatile u_int *)&((dmaChan)->chcr))&0x100) \
        ; \
} \
while (0);

#define sweInlineDmaSendN(dmaChan, addr, size) \
do \
{ \
    tD_CHCR chcr; \
    while ((*(volatile u_int *)&((dmaChan)->chcr))&0x100) \
        ; \
    (dmaChan)->madr = (sceDmaTag *)(addr); \
    (dmaChan)->qwc = (size); \
    chcr = (dmaChan)->chcr; \
    chcr.MOD = 0; \
    chcr.DIR = 1; \
    chcr.STR = 1; \
    (dmaChan)->chcr = chcr; \
} \
while (0);


/* RWPUBLIC */
#if (!defined(RXPIPELINE))
#define RXPIPELINE
#endif /* (!defined(RXPIPELINE)) */
/* RWPUBLICEND */

#endif /* _DMAMACROS_H */

