/***************************************************************************
 *                                                                         *
 * Module  : drvfns.h (sky)                                                *
 *                                                                         *
 * Purpose : Driver functionality                                          *
 *                                                                         *
 **************************************************************************/

#ifndef DRVFNS_H
#define DRVFNS_H

/****************************************************************************
 Includes
 */

#include "batypes.h"
#include "bacolor.h"
#include "batextur.h"

/* Lets hope that gcc's constant folding works */

/* RWPUBLIC */

enum RpSkyRenderState
{
    rpSKYRENDERSTATENARENDERSTATE = 0,
    rpSKYRENDERSTATEDITHER, /**< 0=off, 0x55555555=half, else on */
    rpSKYRENDERSTATEALPHA_1,    /**< ALPHA_1 register with FIX in bits 24-31*/
                                /* Allows us to pass a constant in rather */
                                /* than a pointer to a long */
    rpSKYRENDERSTATEATEST_1, /**< Bottom 16 bits of TEST_1 register */
    rpSKYRENDERSTATEFARFOGPLANE, /**< Specify the Maximum Fog Distance */
    rpSKYRENDERSTATEMAXMIPLEVELS, /**< Max number of mip levels rasters are 
                                   *  created with. Must be <= 7. 
                                   *  Mip levels are still only created 
                                   *  if >8 texels in both dimensions. */
    rpSKYRENDERSTATEFORCEENUMSIZEINT = RWFORCEENUMSIZEINT
};
typedef enum RpSkyRenderState RpSkyRenderState;

/****************************************************************************
 Function prototypes
 */
#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

#define RwSkyInitWorldPipeline() (TRUE)

extern RwBool RpSkySelectDeepZBuffer(RwBool val);

extern RwReal RpSkyTextureSetDefaultMipmapK(RwReal val);
extern RwUInt32 RpSkyTextureSetDefaultMipmapL(RwUInt32 val);
extern RwReal RpSkyTextureGetDefaultMipmapK(void);
extern RwUInt32 RpSkyTextureGetDefaultMipmapL(void);
extern RwTexture *RpSkyTextureSetMipmapK(RwTexture *tex, RwReal val);
extern RwTexture *RpSkyTextureSetMipmapL(RwTexture *tex, RwUInt32 val);
extern RwReal RpSkyTextureGetMipmapK(RwTexture *tex);
extern RwUInt32 RpSkyTextureGetMipmapL(RwTexture *tex);

extern RwBool RpSkyTextureCacheSetState(RwInt32 nFlags);

extern RwBool RpSkySelectTrueTSClipper(RwBool val);
extern RwBool RpSkyGetTrueTSClipper(void);

extern RwBool RpSkySelectTrueTLClipper(RwBool val);
extern RwBool RpSkyGetTrueTLClipper(void);

extern RwBool RpSkyRenderStateSet(RpSkyRenderState nState, void *pParam);
extern RwBool RpSkyRenderStateGet(RpSkyRenderState nState, void *pParam);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

/* RWPUBLICEND */

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

#ifdef SHOWUPLOADEDTEXTURES
extern void skyTexCacheShowUploads(RwBool bShow);
#endif

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#endif /* DRVFNS_H */
