/* Hacked down from gprof sources. Really we should include from the sources,
   but not everybody has the source on line, hence the local copy */
#ifndef _GMON_H
#define _GMON_H

struct raw_phdr
{
    char low_pc[4];     /* base pc address of sample buffer */
    char high_pc[4];        /* max pc address of sampled buffer */
    char ncnt[4];       /* size of sample buffer (plus this header) */

#ifdef BSD44_FORMAT
    char version[4];            /* version number */
    char profrate[4];           /* profiling clock rate */
    char spare[3*4];            /* reserved */
#endif
};

/*
 * Histogram counters are unsigned shorts:
 */
#define HISTCOUNTER unsigned short

/*
 * Fraction of text space to allocate for histogram counters here, 1/2:
 */
#define HISTFRACTION    2

/*
 * Fraction of text space to allocate for from hash buckets.  The
 * value of HASHFRACTION is based on the minimum number of bytes of
 * separation between two subroutine call points in the object code.
 * Given MIN_SUBR_SEPARATION bytes of separation the value of
 * HASHFRACTION is calculated as:
 *
 *      HASHFRACTION = MIN_SUBR_SEPARATION / (2 * sizeof(short) - 1);
 *
 * For the VAX, the shortest two call sequence is:
 *
 *      calls   $0,(r0)
 *      calls   $0,(r0)
 *
 * which is separated by only three bytes, thus HASHFRACTION is 
 * calculated as:
 *
 *      HASHFRACTION = 3 / (2 * 2 - 1) = 1
 *
 * Note that the division above rounds down, thus if MIN_SUBR_FRACTION
 * is less than three, this algorithm will not work!
 */
#define HASHFRACTION 2

/*
 * Percent of text space to allocate for tostructs with a minimum:
 */
#define ARCDENSITY  2
#define MINARCS     50

struct tostruct
{
    char *selfpc;
    int count;
    unsigned short link;
};

/*
 * A raw arc, with pointers to the calling site and the called site
 * and a count.  Everything is defined in terms of characters so
 * as to get a packed representation (otherwise, different compilers
 * might introduce different padding):
 */
struct raw_arc
{
    char from_pc[4];
    char self_pc[4];
    char count[4];
};

/*
 * General rounding functions:
 */
#define ROUNDDOWN(x,y)  (((x)/(y))*(y))
#define ROUNDUP(x,y)    ((((x)+(y)-1)/(y))*(y))

/* I put the visible functions here */
extern void monstartup(char *lowpc, char *highpc);
extern void _mcleanup(void);
extern void moncontrol(int mode);


/* RWPUBLIC */
#if (!defined(RXPIPELINE))
#define RXPIPELINE
#endif /* (!defined(RXPIPELINE)) */
/* RWPUBLICEND */

/* interface to fake profil */

extern unsigned char *swePHbuf;
extern size_t swePHbufsize;
extern size_t swePHoffset;
extern unsigned int swePHscale;
extern long sweProfORH;
extern long sweProfORL;

#endif /* _GMON_H */
