/***************************************************************************
 *                                                                         *
 * Module  : texcache.h                                                    *
 *                                                                         *
 * Purpose : Texture cache for Playstation II                              *
 *                                                                         *
 **************************************************************************/

#ifndef RWTEXCACHE_H
#define RWTEXCACHE_H

/****************************************************************************
 Includes
 */

#include "batypes.h"
#include "baraster.h"
#include "bacamera.h"
#include "basky.h"


/****************************************************************************
 Defines
 */

/****************************************************************************
 Global Types
 */
/* RWPUBLIC */

/* callback type used to signal a raster is needed and is not in cache */
typedef void (*SkyCacheCallBack)(RwRaster *, RwBool);

/* RWPUBLICEND */


/****************************************************************************
 Function prototypes
 */

/* RWPUBLIC */

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */


#ifdef ASYNCTEXTURES
extern void     RpSkyTexCacheAccessSpeculate(RwRaster *raster);
#else /* ASYNCTEXTURES */
#define         RpSkyTexCacheAccessSpeculate(raster)
#endif /* ASYNCTEXTURES */
extern RwBool   RpSkyTexCacheAccessRaster(RwRaster *raster, RwBool useContext2);
extern void     RpSkyTexCacheReleaseRaster(RwRaster *rpRas);
extern RwBool   RpSkyTexCacheRasterLock(RwRaster *raster, RwBool bLocked);
#ifdef ASYNCTEXTURES
extern void     RpSkyTexCacheRasterUnlockAll(void);
#endif /* ASYNCTEXTURES */
extern void     RpSkyTexCacheFlush(void);
extern void     RpSkyTexCacheRestore(void);

/* Theses were the old names which were used when this wasn't exposed */
#define skyTexCacheAccessRaster  RpSkyTexCacheAccessRaster
#define skyTexCacheReleaseRaster RpSkyTexCacheReleaseRaster
#define skyTexCacheRasterLock    RpSkyTexCacheRasterLock
#define skyTexCacheFlush         RpSkyTexCacheFlush
#define skyTexCacheRestore       RpSkyTexCacheRestore

/* This function remains for backwards compatability. It doesn't do what you
   might think */
extern RwBool   RpSkyTextureCacheSetState(RwInt32 nFlags);

/* This is still considered to be a non-firstclass function */
extern void     skyPrepareUploadRaster(RwRaster *raster);

/* A cache overload API is provided to enable wholesale replacement of the
  cache. This is used some where the application has special requirements. */
#ifdef ASYNCTEXTURES
extern RwBool   RpSkyTexCacheDisable(RwBool disable);
#else /* ASYNCTEXTURES */
extern RwBool   skyTexCacheDisable(void);
#endif /* ASYNCTEXTURES */
extern RwUInt32 RpSkyTexGetStartAddress(void);
extern RwUInt32 RpSkyTexGetSize(void);
extern RwBool   RpSkyTexCacheSetCallBack(SkyCacheCallBack fpCacheCB);
extern RwUInt32 RpSkyTexCacheRasterGetAddr(RwRaster *r);
extern RwRaster *RpSkyTexSetTex0(RwRaster *r, RwUInt32 msb, RwUInt32 lsb);
extern RwRaster *RpSkyTexGetTex0(RwRaster *r, RwUInt32 *msb, RwUInt32 *lsb);
extern RwRaster *RpSkyTexSetMiptbp1(RwRaster *r, RwUInt32 msb, RwUInt32 lsb);
extern RwRaster *RpSkyTexGetMiptbp1(RwRaster *r, RwUInt32 *msb, RwUInt32 *lsb);
extern RwRaster *RpSkyTexSetMiptbp12(RwRaster *r, RwUInt32 msb1, RwUInt32 lsb1,
                                     RwUInt32 msb2, RwUInt32 lsb2);
extern RwRaster *RpSkyTexGetMiptbp12(RwRaster *r, RwUInt32 *msb1,
                                     RwUInt32 *lsb1, RwUInt32 *msb2,
                                     RwUInt32 *lsb2);
extern RwRaster *RpSkyTexCacheValidateRaster(RwRaster *r, RwBool valid);
extern RwBool   RpSkyUploadPixelData(RwUInt32 pixelWidth,
                                   RwUInt32 pixelHeight,
                                   RwUInt8 *srcAddress,
                                   RwUInt32 dstAddress,
                                   RwUInt32 dstWidthBy64,
                                   RwUInt32 bitsPerPixel,
                                   RwUInt32 pixelFormat,
                                   RwUInt32 srcStride);
/* Provided to allow faster upload of textures of type "flags&1" */
extern RwRaster *RpSkyTexCacheUploadRaster(RwRaster *r, RwUInt32 dstAddress);

#ifdef ASYNCTEXTURES
#define skyTexCacheDisable()      RpSkyTexCacheDisable(TRUE)
#endif /* ASYNCTEXTURES */
#define skyTexGetStartAddress     RpSkyTexGetStartAddress
#define skyTexCacheSetCallback    RpSkyTexCacheSetCallback
#define RpSkyTexCacheSetCallback  RpSkyTexCacheSetCallBack
#define skyTexCacheRasterGetAddr  RpSkyTexCacheRasterGetAddr
#define skyTexSetTex0             RpSkyTexSetTex0
#define skyTexGetTex0             RpSkyTexGetTex0
#define skyTexSetMiptbp1          RpSkyTexSetMiptbp1
#define skyTexGetMiptbp1          RpSkyTexGetMiptbp1
#define skyTexCacheValidateRaster RpSkyTexCacheValidateRaster
#define skyUploadPixelData        RpSkyUploadPixelData

/* You shouldn't have to access this variable */
extern RwUInt32 skyGNumTexMemBlocks;

#ifndef ASYNCTEXTURES
extern RwBool   skyTexCacheSetSnoopCallback(SkyCacheSnoopCallBack fpCacheCB);
#endif /* ASYNCTEXTURES */

/* RWPUBLICEND */


extern RwBool   skyTexCacheOpenCache(RwInt32 start, RwInt32 size);
extern RwBool   skyTexCacheCloseCache(void);

/* This hook remains available, but is unused */
extern void     skyTexCacheEndFrame(void);

#if (0)
extern u_long128   *
skyFillInPktForUpLoadAlignedContiguousRectangle(u_long128 * pkt,
                                                RwUInt8 * src,
                                                RwUInt64 bytesInRectangle,
                                                RwUInt8 cachedPacket);
#endif /* (0) */

/* RWPUBLIC */

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#if (!defined(RXPIPELINE))
#define RXPIPELINE
#endif /* (!defined(RXPIPELINE)) */
/* RWPUBLICEND */

#endif /* RWTEXCACHE_H */
