#ifndef RPLABELPLUGIN_H
#define RPLABELPLUGIN_H

/*
 * Label plugin
 */


#include <rwcore.h>
#include <rpworld.h>

/**
 * \defgroup rplabel RpLabel
 * \ingroup retired
 *
 * Label Plug-In for RenderWare.
 */

/**
 * \ingroup rplabel
 * \ref RpLabelCallBack is the callback function supplied to \ref RpLabelForAllComments.
 *
 * Your function will be passed a pointer to the comment itself.
 * Optionally, the callback will be passed a pointer to a user-defined
 * data structure.
 * This will be passed in data.
 * If no such structure was specified, this will be NULL.
 * Note that the header file rplabel.h must be included, and the program
 * should be linked to rplabel.lib.
 * 
 * \param  comment   Pointer to comment, supplied to by iterator.
 * \param  data  Pointer to developer-defined data structure.
 * 
 * \return
 * Returns a pointer to the label if successful or NULL if an error occurred.
 * 
 * \see RpLabelPluginAttach
 * \see RpLabelFrameGetLabel
 * \see RpLabelForAllComments
 */
typedef RwChar *(*RpLabelCallBack) (RwChar * comment, void *data);

typedef struct RpLabel RpLabel;

#ifdef __cplusplus
extern              "C"
{
#endif

extern RwBool       RpLabelPluginAttach(void);
extern RpLabel     *RpLabelAddComment(RpLabel * label,
                                      const RwChar * comment);
extern RpLabel     *RpLabelFrameGetLabel(RwFrame * frame);
extern RpLabel     *RpLabelForAllComments(RpLabel * label,
                                          RpLabelCallBack callback,
                                          void *data);

#ifdef __cplusplus
}
#endif

#endif                          /* RPLABELPLUGIN_H */

